/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.properties.SoftwareServerCapabilitiesProperties;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers.", externalDocs=@ExternalDocumentation(description="Data Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/data-manager/"))
public class DataManagerOMASResource {
    private DataManagerRESTServices restAPI = new DataManagerRESTServices();

    @GetMapping(path={"/topics/out-topic-connection"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getOutTopicConnection(serverName, userId);
    }

    @PostMapping(path={"/integrators"})
    public GUIDResponse createDataManagerIntegrator(@PathVariable String serverName, @PathVariable String userId, @RequestBody SoftwareServerCapabilitiesProperties integratorCapabilities) {
        return this.restAPI.createDataManagerIntegrator(serverName, userId, integratorCapabilities);
    }

    @GetMapping(path={"integrators/by-name/{qualifiedName}"})
    public GUIDResponse getDataManagerIntegratorGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getDataManagerIntegratorGUID(serverName, userId, qualifiedName);
    }
}

