/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseViewProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemaResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemasResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTableResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTablesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabasesResponse;
import org.odpi.openmetadata.accessservices.datamanager.server.DatabaseManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data manager such as database servers, content managers and file systems.", externalDocs=@ExternalDocumentation(description="Data Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/data-manager/"))
public class DatabaseManagerResource {
    private DatabaseManagerRESTServices restAPI = new DatabaseManagerRESTServices();

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases"})
    public GUIDResponse createDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @RequestBody DatabaseProperties databaseProperties) {
        return this.restAPI.createDatabase(serverName, userId, integratorGUID, integratorName, databaseProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String templateGUID, @RequestBody TemplateProperties templateProperties) {
        return this.restAPI.createDatabaseFromTemplate(serverName, userId, integratorGUID, integratorName, templateGUID, templateProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/{databaseGUID}"})
    public VoidResponse updateDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseGUID, @RequestBody DatabaseProperties databaseProperties) {
        return this.restAPI.updateDatabase(serverName, userId, integratorGUID, integratorName, databaseGUID, databaseProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/{databaseGUID}/publish"})
    public VoidResponse publishDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.publishDatabase(serverName, userId, integratorGUID, integratorName, databaseGUID, nullRequestBody);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/{databaseGUID}/withdraw"})
    public VoidResponse withdrawDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.withdrawDatabase(serverName, userId, integratorGUID, integratorName, databaseGUID, nullRequestBody);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/{databaseGUID}/{qualifiedName}/delete"})
    public VoidResponse removeDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseGUID, @PathVariable String qualifiedName, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.removeDatabase(serverName, userId, integratorGUID, integratorName, databaseGUID, qualifiedName, nullRequestBody);
    }

    @GetMapping(path={"/databases/by-search-string/{searchString}"})
    public DatabasesResponse findDatabases(@PathVariable String serverName, @PathVariable String userId, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabases(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/by-name/{name}"})
    public DatabasesResponse getDatabasesByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabasesByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/for-integrator/{integratorGUID}/{integratorName}"})
    public DatabasesResponse getDatabasesByDaemon(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabasesByDaemon(serverName, userId, integratorGUID, integratorName, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/{guid}"})
    public DatabaseResponse getDatabaseByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/{databaseGUID}/schemas"})
    public GUIDResponse createDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseGUID, @RequestBody DatabaseSchemaProperties databaseSchemaProperties) {
        return this.restAPI.createDatabaseSchema(serverName, userId, integratorGUID, integratorName, databaseGUID, databaseSchemaProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/{databaseGUID}/schemas/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseSchemaFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String templateGUID, @PathVariable String databaseGUID, @RequestBody TemplateProperties templateProperties) {
        return this.restAPI.createDatabaseSchemaFromTemplate(serverName, userId, integratorGUID, integratorName, templateGUID, databaseGUID, templateProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}"})
    public VoidResponse updateDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseSchemaGUID, @RequestBody DatabaseSchemaProperties databaseSchemaProperties) {
        return this.restAPI.updateDatabaseSchema(serverName, userId, integratorGUID, integratorName, databaseSchemaGUID, databaseSchemaProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}/publish"})
    public VoidResponse publishDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseSchemaGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.publishDatabaseSchema(serverName, userId, integratorGUID, integratorName, databaseSchemaGUID, nullRequestBody);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}/withdraw"})
    public VoidResponse withdrawDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseSchemaGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.withdrawDatabase(serverName, userId, integratorGUID, integratorName, databaseSchemaGUID, nullRequestBody);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}/{qualifiedName}/delete"})
    public VoidResponse removeDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseSchemaGUID, @PathVariable String qualifiedName, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.removeDatabaseSchema(serverName, userId, integratorGUID, integratorName, databaseSchemaGUID, qualifiedName, nullRequestBody);
    }

    @GetMapping(path={"/databases/schemas/by-search-string/{searchString}"})
    public DatabaseSchemasResponse findDatabaseSchemas(@PathVariable String serverName, @PathVariable String userId, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabaseSchemas(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/{databaseGUID}/schemas"})
    public DatabaseSchemasResponse getSchemasForDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSchemasForDatabase(serverName, userId, databaseGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/by-name/{name}"})
    public DatabaseSchemasResponse getDatabaseSchemasByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabaseSchemasByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/{guid}"})
    public DatabaseSchemaResponse getDatabaseSchemaByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseSchemaByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}/tables"})
    public GUIDResponse createDatabaseTable(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseSchemaGUID, @RequestBody DatabaseTableProperties databaseTableProperties) {
        return this.restAPI.createDatabaseTable(serverName, userId, integratorGUID, integratorName, databaseSchemaGUID, databaseTableProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}/tables/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseTableFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String templateGUID, @PathVariable String databaseSchemaGUID, @RequestBody TemplateProperties templateProperties) {
        return this.restAPI.createDatabaseTableFromTemplate(serverName, userId, integratorGUID, integratorName, templateGUID, databaseSchemaGUID, templateProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}/tables/{databaseTableGUID}"})
    public VoidResponse updateDatabaseTable(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseTableGUID, @RequestBody DatabaseTableProperties databaseTableProperties) {
        return this.restAPI.updateDatabaseTable(serverName, userId, integratorGUID, integratorName, databaseTableGUID, databaseTableProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}/tables/{databaseTableGUID}/{qualifiedName}/delete"})
    public VoidResponse removeDatabaseTable(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseTableGUID, @PathVariable String qualifiedName, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.removeDatabaseTable(serverName, userId, integratorGUID, integratorName, databaseTableGUID, qualifiedName, nullRequestBody);
    }

    @GetMapping(path={"/databases/schemas/tables/by-search-string/{searchString}"})
    public DatabaseTablesResponse findDatabaseTables(@PathVariable String serverName, @PathVariable String userId, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabaseTables(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/{databaseSchemaGUID}/tables"})
    public DatabaseTablesResponse getTablesForDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseSchemaGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getTablesForDatabaseSchema(serverName, userId, databaseSchemaGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/tables/by-name/{name}"})
    public DatabaseTablesResponse getDatabaseTablesByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabaseTablesByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/tables/{guid}"})
    public DatabaseTableResponse getDatabaseTableByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseTableByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}/tables/views"})
    public GUIDResponse createDatabaseView(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseSchemaGUID, @RequestBody DatabaseViewProperties databaseViewProperties) {
        return this.restAPI.createDatabaseView(serverName, userId, integratorGUID, integratorName, databaseSchemaGUID, databaseViewProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/{databaseSchemaGUID}/tables/views/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseViewFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String templateGUID, @PathVariable String databaseSchemaGUID, @RequestBody TemplateProperties templateProperties) {
        return this.restAPI.createDatabaseViewFromTemplate(serverName, userId, integratorGUID, integratorName, templateGUID, databaseSchemaGUID, templateProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/views/{databaseViewGUID}"})
    public VoidResponse updateDatabaseView(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseViewGUID, @RequestBody DatabaseViewProperties databaseViewProperties) {
        return this.restAPI.updateDatabaseView(serverName, userId, integratorGUID, integratorName, databaseViewGUID, databaseViewProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/views/{databaseViewGUID}/{qualifiedName}/delete"})
    public VoidResponse removeDatabaseView(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseViewGUID, @PathVariable String qualifiedName, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.removeDatabaseView(serverName, userId, integratorGUID, integratorName, databaseViewGUID, qualifiedName, nullRequestBody);
    }

    @GetMapping(path={"/databases/schemas/tables/views/by-search-string/{searchString}"})
    public DatabaseViewsResponse findDatabaseViews(@PathVariable String serverName, @PathVariable String userId, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabaseViews(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/{databaseSchemaGUID}/tables/views"})
    public DatabaseViewsResponse getViewsForDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseSchemaGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getViewsForDatabaseSchema(serverName, userId, databaseSchemaGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/tables/views/by-name/{name}"})
    public DatabaseViewsResponse getDatabaseViewsByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabaseViewsByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/tables/views/{guid}"})
    public DatabaseViewResponse getDatabaseViewByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseViewByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/{databaseTableGUID}/columns"})
    public GUIDResponse createDatabaseColumn(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseTableGUID, @RequestBody DatabaseColumnProperties databaseColumnProperties) {
        return this.restAPI.createDatabaseColumn(serverName, userId, integratorGUID, integratorName, databaseTableGUID, databaseColumnProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/{databaseTableGUID}/columns/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseColumnFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String templateGUID, @PathVariable String databaseTableGUID, @RequestBody TemplateProperties templateProperties) {
        return this.restAPI.createDatabaseColumnFromTemplate(serverName, userId, integratorGUID, integratorName, templateGUID, databaseTableGUID, templateProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/columns/{databaseColumnGUID}"})
    public VoidResponse updateDatabaseColumn(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseColumnGUID, @RequestBody DatabaseColumnProperties databaseColumnProperties) {
        return this.restAPI.updateDatabaseColumn(serverName, userId, integratorGUID, integratorName, databaseColumnGUID, databaseColumnProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/columns/{databaseColumnGUID}/{qualifiedName}/delete"})
    public VoidResponse removeDatabaseColumn(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseColumnGUID, @PathVariable String qualifiedName, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.removeDatabaseColumn(serverName, userId, integratorGUID, integratorName, databaseColumnGUID, qualifiedName, nullRequestBody);
    }

    @GetMapping(path={"/databases/schemas/tables/columns/by-search-string/{searchString}"})
    public DatabaseColumnsResponse findDatabaseColumns(@PathVariable String serverName, @PathVariable String userId, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabaseColumns(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/tables/{databaseTableGUID}/columns"})
    public DatabaseColumnsResponse getColumnsForDatabaseTable(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseTableGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getColumnsForDatabaseTable(serverName, userId, databaseTableGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/tables/columns/by-name/{name}"})
    public DatabaseColumnsResponse getDatabaseColumnsByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabaseColumnsByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/tables/columns/{guid}"})
    public DatabaseColumnResponse getDatabaseColumnByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseColumnByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/columns/{databaseColumnGUID}/primary-key"})
    public VoidResponse setPrimaryKeyOnColumn(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseColumnGUID, @RequestBody DatabasePrimaryKeyProperties databasePrimaryKeyProperties) {
        return this.restAPI.setPrimaryKeyOnColumn(serverName, userId, integratorGUID, integratorName, databaseColumnGUID, databasePrimaryKeyProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/columns/{databaseColumnGUID}/primary-key/delete"})
    public VoidResponse removePrimaryKeyFromColumn(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String databaseColumnGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.removePrimaryKeyFromColumn(serverName, userId, integratorGUID, integratorName, databaseColumnGUID, nullRequestBody);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/columns/{foreignKeyColumnGUID}/foreign-key/{primaryKeyColumnGUID}"})
    public VoidResponse addForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String primaryKeyColumnGUID, @PathVariable String foreignKeyColumnGUID, @RequestBody DatabaseForeignKeyProperties databaseForeignKeyProperties) {
        return this.restAPI.addForeignKeyRelationship(serverName, userId, integratorGUID, integratorName, primaryKeyColumnGUID, foreignKeyColumnGUID, databaseForeignKeyProperties);
    }

    @PostMapping(path={"/integrators/{integratorGUID}/{integratorName}/databases/schemas/tables/columns/{foreignKeyColumnGUID}/foreign-key/{primaryKeyColumnGUID}/delete"})
    public VoidResponse removeForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integratorGUID, @PathVariable String integratorName, @PathVariable String primaryKeyColumnGUID, @PathVariable String foreignKeyColumnGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.removeForeignKeyRelationship(serverName, userId, integratorGUID, integratorName, primaryKeyColumnGUID, foreignKeyColumnGUID, nullRequestBody);
    }
}

