/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFolderRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileFolderResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileSystemResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.PathNameRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.FilesRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers.", externalDocs=@ExternalDocumentation(description="Data Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/data-manager/"))
public class FilesResource {
    private FilesRESTServices restAPI = new FilesRESTServices();

    @PostMapping(path={"/filesystems/folders/{parentGUID}"})
    public GUIDListResponse createFolderStructureInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentGUID, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.createFolderStructureInCatalog(serverName, userId, parentGUID, requestBody);
    }

    @PostMapping(path={"/filesystems/{fileSystemGUID}/{fileSystemName}/folders"})
    public GUIDListResponse createFolderStructureInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @PathVariable String fileSystemName, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.createFolderStructureInCatalog(serverName, userId, fileSystemGUID, fileSystemName, requestBody);
    }

    @PostMapping(path={"/filesystems/{fileSystemGUID}/folders/{fileSystemGUID}/attach"})
    public VoidResponse attachFolderToFileSystem(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @PathVariable String folderGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.attachFolderToFileSystem(serverName, userId, fileSystemGUID, folderGUID, requestBody);
    }

    @PostMapping(path={"/filesystems/{fileSystemGUID}/folders/{fileSystemGUID}/detach"})
    public VoidResponse detachFolderFromFileSystem(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @PathVariable String folderGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachFolderFromFileSystem(serverName, userId, fileSystemGUID, folderGUID, requestBody);
    }

    @PostMapping(path={"/filesystems/{fileSystemGUID}/{fileSystemName}/data-files"})
    public GUIDListResponse addDataFileToCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @PathVariable String fileSystemName, @RequestBody DataFileRequestBody requestBody) {
        return this.restAPI.addDataFileToCatalog(serverName, userId, fileSystemGUID, fileSystemName, requestBody);
    }

    @PostMapping(path={"/filesystems/{fileSystemGUID}/{fileSystemName}/data-folders"})
    public GUIDListResponse addDataFolderAssetToCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @PathVariable String fileSystemName, @RequestBody DataFolderRequestBody requestBody) {
        return this.restAPI.addDataFolderAssetToCatalog(serverName, userId, fileSystemGUID, fileSystemName, requestBody);
    }

    @PostMapping(path={"/folders/{folderGUID}/assets/data-files/{fileGUID}/attach"})
    public VoidResponse attachDataFileAssetToFolder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String fileGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.attachDataFileAssetToFolder(serverName, userId, folderGUID, fileGUID, requestBody);
    }

    @PostMapping(path={"/folders/{folderGUID}/assets/data-files/{fileGUID}/detach"})
    public VoidResponse detachDataFileAssetFromFolder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String fileGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachDataFileAssetFromFolder(serverName, userId, folderGUID, fileGUID, requestBody);
    }

    @PostMapping(path={"/folders/{folderGUID}/assets/data-files/{fileGUID}/move-to"})
    public VoidResponse moveDataFileInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String fileGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.moveDataFileInCatalog(serverName, userId, folderGUID, fileGUID, requestBody);
    }

    @PostMapping(path={"/folders/{folderGUID}/assets/data-folders/{dataFolderGUID}/move-to"})
    public VoidResponse moveDataFolderInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String dataFolderGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.moveDataFolderInCatalog(serverName, userId, folderGUID, dataFolderGUID, requestBody);
    }

    @GetMapping(path={"/filesystems/{fileSystemGUID}"})
    public FileSystemResponse getFileSystemByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID) {
        return this.restAPI.getFileSystemByGUID(serverName, userId, fileSystemGUID);
    }

    @GetMapping(path={"/filesystems/by-name/{uniqueName}"})
    public FileSystemResponse getFileSystemByUniqueName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String uniqueName) {
        return this.restAPI.getFileSystemByUniqueName(serverName, userId, uniqueName);
    }

    @GetMapping(path={"/filesystems"})
    public GUIDListResponse getFileSystems(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getFileSystems(serverName, userId, startingFrom, maxPageSize);
    }

    @GetMapping(path={"/folders/{folderGUID}"})
    public FileFolderResponse getFolderByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID) {
        return this.restAPI.getFolderByGUID(serverName, userId, folderGUID);
    }

    @GetMapping(path={"/folders/by-path-name"})
    public FileFolderResponse getFolderByPathName(@PathVariable String serverName, @PathVariable String userId, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.getFolderByPathName(serverName, userId, requestBody);
    }

    @GetMapping(path={"/{anchorGUID}/folders"})
    public GUIDListResponse getNestedFolders(@PathVariable String serverName, @PathVariable String userId, @PathVariable String anchorGUID, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getNestedFolders(serverName, userId, anchorGUID, startingFrom, maxPageSize);
    }

    @GetMapping(path={"/folders/{folderGUID}/files"})
    public GUIDListResponse getFolderFiles(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getFolderFiles(serverName, userId, folderGUID, startingFrom, maxPageSize);
    }

    @GetMapping(path={"/files/{dataFileGUID}"})
    public DataFileResponse getDataFilesByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFileGUID) {
        return this.restAPI.getDataFileByGUID(serverName, userId, dataFileGUID);
    }

    @GetMapping(path={"/files/by-path-name"})
    public DataFileResponse getDataFileByPathName(@PathVariable String serverName, @PathVariable String userId, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.getDataFileByPathName(serverName, userId, requestBody);
    }
}

