/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileSystemRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers.", externalDocs=@ExternalDocumentation(description="Data Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/data-manager"))
public class DataManagerOMASResource {
    private DataManagerRESTServices restAPI = new DataManagerRESTServices();

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/metadata-sources/filesystems"})
    public GUIDResponse createFileSystemInCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody FileSystemRequestBody requestBody) {
        return this.restAPI.createFileSystemInCatalog(serverName, userId, requestBody);
    }

    @PostMapping(path={"/metadata-sources/file-managers"})
    public GUIDResponse createFileManagerInCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody FileManagerRequestBody requestBody) {
        return this.restAPI.createFileManagerInCatalog(serverName, userId, requestBody);
    }

    @PostMapping(path={"/metadata-sources/database-managers"})
    public GUIDResponse createDatabaseManager(@PathVariable String serverName, @PathVariable String userId, @RequestBody DatabaseManagerRequestBody requestBody) {
        return this.restAPI.createDatabaseManagerInCatalog(serverName, userId, requestBody);
    }

    @GetMapping(path={"metadata-sources/by-name/{qualifiedName}"})
    public GUIDResponse getMetadataSourceGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getMetadataSourceGUID(serverName, userId, qualifiedName);
    }
}

