/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventTypeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventTypesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TopicRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TopicResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.TopicsResponse;
import org.odpi.openmetadata.accessservices.datamanager.server.EventBrokerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers such as database servers, event brokers, content managers and file systems.", externalDocs=@ExternalDocumentation(description="Data Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/data-manager/"))
public class EventBrokerResource {
    private EventBrokerRESTServices restAPI = new EventBrokerRESTServices();

    @PostMapping(path={"/topics"})
    public GUIDResponse createTopic(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean eventBrokerIsHome, @RequestBody TopicRequestBody requestBody) {
        return this.restAPI.createTopic(serverName, userId, eventBrokerIsHome, requestBody);
    }

    @PostMapping(path={"/topics/from-template/{templateGUID}"})
    public GUIDResponse createTopicFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean eventBrokerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createTopicFromTemplate(serverName, userId, templateGUID, eventBrokerIsHome, requestBody);
    }

    @PostMapping(path={"/topics/{topicGUID}"})
    public VoidResponse updateTopic(@PathVariable String serverName, @PathVariable String userId, @PathVariable String topicGUID, @RequestParam boolean isMergeUpdate, @RequestBody TopicRequestBody requestBody) {
        return this.restAPI.updateTopic(serverName, userId, topicGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/topics/{topicGUID}/publish"})
    public VoidResponse publishTopic(@PathVariable String serverName, @PathVariable String userId, @PathVariable String topicGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.publishTopic(serverName, userId, topicGUID, nullRequestBody);
    }

    @PostMapping(path={"/topics/{topicGUID}/withdraw"})
    public VoidResponse withdrawTopic(@PathVariable String serverName, @PathVariable String userId, @PathVariable String topicGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.withdrawTopic(serverName, userId, topicGUID, nullRequestBody);
    }

    @PostMapping(path={"/topics/{topicGUID}/{qualifiedName}/delete"})
    public VoidResponse removeTopic(@PathVariable String serverName, @PathVariable String userId, @PathVariable String topicGUID, @PathVariable String qualifiedName, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeTopic(serverName, userId, topicGUID, qualifiedName, requestBody);
    }

    @GetMapping(path={"/topics/by-search-string/{searchString}"})
    public TopicsResponse findTopics(@PathVariable String serverName, @PathVariable String userId, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findTopics(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/topics/by-name/{name}"})
    public TopicsResponse getTopicsByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getTopicsByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/event-brokers/{eventBrokerGUID}/{eventBrokerName}/topics"})
    public TopicsResponse getTopicsForEventBroker(@PathVariable String serverName, @PathVariable String userId, @PathVariable String eventBrokerGUID, @PathVariable String eventBrokerName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getTopicsForEventBroker(serverName, userId, eventBrokerGUID, eventBrokerName, startFrom, pageSize);
    }

    @GetMapping(path={"/topics/{guid}"})
    public TopicResponse getTopicByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTopicByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/topics/{topicGUID}/event-types"})
    public GUIDResponse createEventType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String topicGUID, @RequestBody EventTypeRequestBody requestBody) {
        return this.restAPI.createEventType(serverName, userId, topicGUID, requestBody);
    }

    @PostMapping(path={"/topics/{topicGUID}/event-types/from-template/{templateGUID}"})
    public GUIDResponse createEventTypeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @PathVariable String topicGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createEventTypeFromTemplate(serverName, userId, templateGUID, topicGUID, requestBody);
    }

    @PostMapping(path={"/topics/event-types/{eventTypeGUID}"})
    public VoidResponse updateEventType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String eventTypeGUID, @RequestParam boolean isMergeUpdate, @RequestBody EventTypeRequestBody requestBody) {
        return this.restAPI.updateEventType(serverName, userId, eventTypeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/topics/event-types/{eventTypeGUID}/{qualifiedName}/delete"})
    public VoidResponse removeEventType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String eventTypeGUID, @PathVariable String qualifiedName, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeEventType(serverName, userId, eventTypeGUID, qualifiedName, requestBody);
    }

    @GetMapping(path={"/topics/event-types/by-search-string/{searchString}"})
    public EventTypesResponse findEventTypes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findEventTypes(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/event-sets/{eventSetGUID}/event-types"})
    public EventTypesResponse getEventTypesForEventSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String eventSetGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEventTypesForEventSet(serverName, userId, eventSetGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/topics/{topicGUID}/event-types"})
    public EventTypesResponse getEventTypesForTopic(@PathVariable String serverName, @PathVariable String userId, @PathVariable String topicGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEventTypesForTopic(serverName, userId, topicGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/topics/event-types/by-name/{name}"})
    public EventTypesResponse getEventTypesByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEventTypesByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/topics/event-types/{guid}"})
    public EventTypeResponse getEventTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getEventTypeByGUID(serverName, userId, guid);
    }
}

