/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.rest.DerivedSchemaTypeQueryTargetRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ElementStubResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.EnumSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FormulaRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.LiteralSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.MapSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.PrimitiveSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaAttributeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypeChoiceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.StructSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ValidValueSetsResponse;
import org.odpi.openmetadata.accessservices.datamanager.server.SchemaManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers such as database servers, event brokers, content managers and file systems.", externalDocs=@ExternalDocumentation(description="Data Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/data-manager/"))
public class SchemaManagerResource {
    private SchemaManagerRESTServices restAPI = new SchemaManagerRESTServices();

    @PostMapping(path={"/schema-types/primitives"})
    public GUIDResponse createPrimitiveSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestBody PrimitiveSchemaTypeRequestBody requestBody) {
        return this.restAPI.createPrimitiveSchemaType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/schema-types/literals"})
    public GUIDResponse createLiteralSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestBody LiteralSchemaTypeRequestBody requestBody) {
        return this.restAPI.createLiteralSchemaType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/schema-types/enums/valid-values/{validValuesSetGUID}"})
    public GUIDResponse createEnumSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValuesSetGUID, @RequestBody EnumSchemaTypeRequestBody requestBody) {
        return this.restAPI.createEnumSchemaType(serverName, userId, validValuesSetGUID, requestBody);
    }

    @GetMapping(path={"/valid-value-sets/by-name/{name}"})
    public ValidValueSetsResponse getValidValueSetByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValueSetByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-value-sets/by-search-string/{searchString}"})
    public ValidValueSetsResponse findValidValueSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findValidValueSet(serverName, userId, searchString, startFrom, pageSize);
    }

    @PostMapping(path={"/schema-types/structs"})
    public GUIDResponse createStructSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestBody StructSchemaTypeRequestBody requestBody) {
        return this.restAPI.createStructSchemaType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/schema-types/choices"})
    public GUIDResponse createSchemaTypeChoice(@PathVariable String serverName, @PathVariable String userId, @RequestBody SchemaTypeChoiceRequestBody requestBody) {
        return this.restAPI.createSchemaTypeChoice(serverName, userId, requestBody);
    }

    @PostMapping(path={"/schema-types/maps/from/{mapFromSchemaTypeGUID}/to/{mapToSchemaTypeGUID}"})
    public GUIDResponse createMapSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String mapFromSchemaTypeGUID, @PathVariable String mapToSchemaTypeGUID, @RequestBody MapSchemaTypeRequestBody requestBody) {
        return this.restAPI.createMapSchemaType(serverName, userId, mapFromSchemaTypeGUID, mapToSchemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/schema-types/from-template/{templateGUID}"})
    public GUIDResponse createSchemaTypeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createSchemaTypeFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}"})
    public VoidResponse updateSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestParam boolean isMergeUpdate, @RequestBody SchemaTypeRequestBody requestBody) {
        return this.restAPI.updateSchemaType(serverName, userId, schemaTypeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/schema-types/{schemaTypeGUID}/delete"})
    public VoidResponse removeSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeSchemaType(serverName, userId, schemaTypeGUID, requestBody);
    }

    @GetMapping(path={"/schema-types/types/{typeName}/by-search-string/{searchString}"})
    public SchemaTypesResponse findSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findSchemaType(serverName, userId, typeName, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/schema-types/types/{parentElementTypeName}/by-parent-element/{parentElementGUID}"})
    public SchemaTypeResponse getSchemaTypeForElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentElementGUID, @PathVariable String parentElementTypeName) {
        return this.restAPI.getSchemaTypeForElement(serverName, userId, parentElementGUID, parentElementTypeName);
    }

    @GetMapping(path={"/schema-types/types/{typeName}/by-name/{name}"})
    public SchemaTypesResponse getSchemaTypeByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSchemaTypeByName(serverName, userId, typeName, name, startFrom, pageSize);
    }

    @GetMapping(path={"/schema-types/{schemaTypeGUID}"})
    public SchemaTypeResponse getSchemaTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID) {
        return this.restAPI.getSchemaTypeByGUID(serverName, userId, schemaTypeGUID);
    }

    @GetMapping(path={"/schema-types/{schemaTypeGUID}/parent"})
    public ElementStubResponse getSchemaTypeParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID) {
        return this.restAPI.getSchemaTypeParent(serverName, userId, schemaTypeGUID);
    }

    @PostMapping(path={"/schema-attributes/attached-to/{schemaElementGUID}"})
    public GUIDResponse createSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestBody SchemaAttributeRequestBody requestBody) {
        return this.restAPI.createSchemaAttribute(serverName, userId, schemaElementGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/from-template/{templateGUID}/attached-to/{schemaElementGUID}"})
    public GUIDResponse createSchemaAttributeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createSchemaAttributeFromTemplate(serverName, userId, schemaElementGUID, templateGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/schema-types/{schemaTypeGUID}/relationship-type-name/{relationshipTypeName}"})
    public VoidResponse setupSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String schemaAttributeGUID, @PathVariable String schemaTypeGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.setupSchemaType(serverName, userId, relationshipTypeName, schemaAttributeGUID, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/schema-types/delete"})
    public VoidResponse clearSchemaTypes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.clearSchemaTypes(serverName, userId, schemaAttributeGUID, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}"})
    public VoidResponse updateSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestParam boolean isMergeUpdate, @RequestBody SchemaAttributeRequestBody requestBody) {
        return this.restAPI.updateSchemaAttribute(serverName, userId, schemaAttributeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/schema-attributes/{schemaAttributeGUID}/delete"})
    public VoidResponse removeSchemaAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeSchemaAttribute(serverName, userId, schemaAttributeGUID, requestBody);
    }

    @GetMapping(path={"/schema-attributes/types/{typeName}/by-search-string/{searchString}"})
    public SchemaAttributesResponse findSchemaAttributes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findSchemaAttributes(serverName, userId, typeName, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/schema-attributes/{parentSchemaElementGUID}/nested-attributes"})
    public SchemaAttributesResponse getNestedAttributes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentSchemaElementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getNestedAttributes(serverName, userId, parentSchemaElementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/schema-attributes/types/{typeName}/by-name/{name}"})
    public SchemaAttributesResponse getSchemaAttributesByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSchemaAttributesByName(serverName, userId, typeName, name, startFrom, pageSize);
    }

    @GetMapping(path={"/schema-attributes/{schemaAttributeGUID}"})
    public SchemaAttributeResponse getSchemaAttributeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaAttributeGUID) {
        return this.restAPI.getSchemaAttributeByGUID(serverName, userId, schemaAttributeGUID);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/calculated-value"})
    public VoidResponse setupCalculatedValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestBody FormulaRequestBody requestBody) {
        return this.restAPI.setupCalculatedValue(serverName, userId, schemaElementGUID, requestBody);
    }

    @PostMapping(path={"/schema-elements/{schemaElementGUID}/calculated-value/delete"})
    public VoidResponse clearCalculatedValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaElementGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.clearCalculatedValue(serverName, userId, schemaElementGUID, requestBody);
    }

    @PostMapping(path={"/schema-elements/{derivedElementGUID}/query-targets/{queryTargetGUID}"})
    public VoidResponse setupQueryTargetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String derivedElementGUID, @PathVariable String queryTargetGUID, @RequestBody DerivedSchemaTypeQueryTargetRequestBody requestBody) {
        return this.restAPI.setupQueryTargetRelationship(serverName, userId, derivedElementGUID, queryTargetGUID, requestBody);
    }

    @PostMapping(path={"/schema-elements/{derivedElementGUID}/query-targets/{queryTargetGUID}/update"})
    public VoidResponse updateQueryTargetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String derivedElementGUID, @PathVariable String queryTargetGUID, @RequestBody DerivedSchemaTypeQueryTargetRequestBody requestBody) {
        return this.restAPI.updateQueryTargetRelationship(serverName, userId, derivedElementGUID, queryTargetGUID, requestBody);
    }

    @PostMapping(path={"/schema-elements/{derivedElementGUID}/query-targets/{queryTargetGUID}/delete"})
    public VoidResponse clearQueryTargetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String derivedElementGUID, @PathVariable String queryTargetGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.clearQueryTargetRelationship(serverName, userId, derivedElementGUID, queryTargetGUID, requestBody);
    }
}

