/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.rest.ArchiveRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFilesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFolderRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileFolderResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileSystemResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.PathNameRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.FilesRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}/filesystems"})
@Tag(name="Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers such as database servers, event brokers, content managers and file systems.", externalDocs=@ExternalDocumentation(description="Data Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/data-manager/"))
public class FilesResource {
    private FilesRESTServices restAPI = new FilesRESTServices();

    @PostMapping(path={"/folders/parent/{parentGUID}"})
    public GUIDListResponse createFolderStructureInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentGUID, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.createFolderStructureInCatalog(serverName, userId, parentGUID, requestBody);
    }

    @PostMapping(path={"/{fileSystemGUID}/folders/{folderGUID}/attach"})
    public VoidResponse attachFolderToFileSystem(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @PathVariable String folderGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.attachFolderToFileSystem(serverName, userId, fileSystemGUID, folderGUID, requestBody);
    }

    @PostMapping(path={"/{fileSystemGUID}/folders/{folderGUID}/detach"})
    public VoidResponse detachFolderFromFileSystem(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @PathVariable String folderGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachFolderFromFileSystem(serverName, userId, fileSystemGUID, folderGUID, requestBody);
    }

    @PostMapping(path={"/data-files"})
    public GUIDListResponse addDataFileToCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody DataFileRequestBody requestBody) {
        return this.restAPI.addDataFileToCatalog(serverName, userId, requestBody);
    }

    @PostMapping(path={"/data-files/from-template/{templateGUID}"})
    public GUIDListResponse addDataFileToCatalogFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.addDataFileToCatalogFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/data-files/{dataFileGUID}"})
    public VoidResponse updateDataFileInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFileGUID, @RequestParam boolean isMergeUpdate, @RequestBody DataFileRequestBody requestBody) {
        return this.restAPI.updateDataFileInCatalog(serverName, userId, dataFileGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/data-files/{dataFileGUID}/archive"})
    public VoidResponse archiveDataFileInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFileGUID, @RequestBody ArchiveRequestBody requestBody) {
        return this.restAPI.archiveDataFileInCatalog(serverName, userId, dataFileGUID, requestBody);
    }

    @PostMapping(path={"/data-files/{dataFileGUID}/delete"})
    public VoidResponse deleteDataFileFromCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFileGUID, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.deleteDataFileFromCatalog(serverName, userId, dataFileGUID, requestBody);
    }

    @PostMapping(path={"/data-folders"})
    public GUIDListResponse addDataFolderAssetToCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody DataFolderRequestBody requestBody) {
        return this.restAPI.addDataFolderAssetToCatalog(serverName, userId, requestBody);
    }

    @PostMapping(path={"/data-folders/from-template/{templateGUID}"})
    public GUIDListResponse addDataFolderToCatalogFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.addDataFolderToCatalogFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/data-folders/{dataFolderGUID}"})
    public VoidResponse updateDataFolderInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFolderGUID, @RequestParam boolean isMergeUpdate, @RequestBody DataFolderRequestBody requestBody) {
        return this.restAPI.updateDataFolderInCatalog(serverName, userId, dataFolderGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/data-folders/{dataFolderGUID}/archive"})
    public VoidResponse archiveDataFolderInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFolderGUID, @RequestBody ArchiveRequestBody requestBody) {
        return this.restAPI.archiveDataFolderInCatalog(serverName, userId, dataFolderGUID, requestBody);
    }

    @PostMapping(path={"/data-folders/{dataFolderGUID}/delete"})
    public VoidResponse deleteDataFolderFromCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFolderGUID, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.deleteDataFolderFromCatalog(serverName, userId, dataFolderGUID, requestBody);
    }

    @PostMapping(path={"/folders/{folderGUID}/data-files/{fileGUID}/attach"})
    public VoidResponse attachDataFileAssetToFolder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String fileGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.attachDataFileAssetToFolder(serverName, userId, folderGUID, fileGUID, requestBody);
    }

    @PostMapping(path={"/folders/{folderGUID}/data-files/{fileGUID}/detach"})
    public VoidResponse detachDataFileAssetFromFolder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String fileGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachDataFileAssetFromFolder(serverName, userId, folderGUID, fileGUID, requestBody);
    }

    @PostMapping(path={"/folders/{folderGUID}/data-files/{fileGUID}/move-to"})
    public VoidResponse moveDataFileInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String fileGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.moveDataFileInCatalog(serverName, userId, folderGUID, fileGUID, requestBody);
    }

    @PostMapping(path={"/folders/{folderGUID}/data-folders/{dataFolderGUID}/move-to"})
    public VoidResponse moveDataFolderInCatalog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @PathVariable String dataFolderGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.moveDataFolderInCatalog(serverName, userId, folderGUID, dataFolderGUID, requestBody);
    }

    @GetMapping(path={"/filesystems/{fileSystemGUID}"})
    public FileSystemResponse getFileSystemByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID) {
        return this.restAPI.getFileSystemByGUID(serverName, userId, fileSystemGUID);
    }

    @GetMapping(path={"/filesystems/by-name/{uniqueName}"})
    public FileSystemResponse getFileSystemByUniqueName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String uniqueName) {
        return this.restAPI.getFileSystemByUniqueName(serverName, userId, uniqueName);
    }

    @GetMapping(path={"/filesystems"})
    public GUIDListResponse getFileSystems(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getFileSystems(serverName, userId, startingFrom, maxPageSize);
    }

    @GetMapping(path={"/folders/{folderGUID}"})
    public FileFolderResponse getFolderByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID) {
        return this.restAPI.getFolderByGUID(serverName, userId, folderGUID);
    }

    @PostMapping(path={"/folders/by-path-name"})
    public FileFolderResponse getFolderByPathName(@PathVariable String serverName, @PathVariable String userId, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.getFolderByPathName(serverName, userId, requestBody);
    }

    @GetMapping(path={"/{fileSystemGUID}/folders"})
    public GUIDListResponse getTopLevelFolders(@PathVariable String serverName, @PathVariable String userId, @PathVariable String fileSystemGUID, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getTopLevelFolders(serverName, userId, fileSystemGUID, startingFrom, maxPageSize);
    }

    @GetMapping(path={"/folders/{parentFolderGUID}/folders"})
    public GUIDListResponse getNestedFolders(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentFolderGUID, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getNestedFolders(serverName, userId, parentFolderGUID, startingFrom, maxPageSize);
    }

    @GetMapping(path={"/folders/{folderGUID}/data-files"})
    public GUIDListResponse getFolderFiles(@PathVariable String serverName, @PathVariable String userId, @PathVariable String folderGUID, @RequestParam int startingFrom, @RequestParam int maxPageSize) {
        return this.restAPI.getFolderFiles(serverName, userId, folderGUID, startingFrom, maxPageSize);
    }

    @GetMapping(path={"/data-files/{dataFileGUID}"})
    public DataFileResponse getDataFileByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFileGUID) {
        return this.restAPI.getDataFileByGUID(serverName, userId, dataFileGUID);
    }

    @PostMapping(path={"/data-files/by-path-name"})
    public DataFileResponse getDataFileByPathName(@PathVariable String serverName, @PathVariable String userId, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.getDataFileByPathName(serverName, userId, requestBody);
    }

    @PostMapping(path={"/data-files/by-search-path-name"})
    public DataFilesResponse findDataFilesByPathName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maxPageSize, @RequestBody PathNameRequestBody requestBody) {
        return this.restAPI.findDataFilesByPathName(serverName, userId, startingFrom, maxPageSize, requestBody);
    }
}

