/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListType;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIOperationRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIOperationResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIOperationsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIParameterListRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIParameterListResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIParameterListsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.APIManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers such as database servers, event brokers, content managers and file systems.", externalDocs=@ExternalDocumentation(description="Data Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/data-manager/"))
public class APIManagerResource {
    private APIManagerRESTServices restAPI = new APIManagerRESTServices();

    @PostMapping(path={"/apis"})
    public GUIDResponse createAPI(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean apiManagerIsHome, @RequestBody APIRequestBody requestBody) {
        return this.restAPI.createAPI(serverName, userId, apiManagerIsHome, null, requestBody);
    }

    @PostMapping(path={"/apis/for-endpoint/{endpointGUID}"})
    public GUIDResponse createAPI(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestParam boolean apiManagerIsHome, @RequestBody APIRequestBody requestBody) {
        return this.restAPI.createAPI(serverName, userId, apiManagerIsHome, endpointGUID, requestBody);
    }

    @PostMapping(path={"/apis/from-template/{templateGUID}"})
    public GUIDResponse createAPIFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean apiManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createAPIFromTemplate(serverName, userId, null, templateGUID, apiManagerIsHome, requestBody);
    }

    @PostMapping(path={"/apis/for-endpoint/{endpointGUID}/from-template/{templateGUID}"})
    public GUIDResponse createAPIFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @PathVariable String templateGUID, @RequestParam boolean apiManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createAPIFromTemplate(serverName, userId, endpointGUID, templateGUID, apiManagerIsHome, requestBody);
    }

    @PostMapping(path={"/apis/{apiGUID}"})
    public VoidResponse updateAPI(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiGUID, @RequestParam boolean isMergeUpdate, @RequestBody APIRequestBody requestBody) {
        return this.restAPI.updateAPI(serverName, userId, apiGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/apis/{apiGUID}/publish"})
    public VoidResponse publishAPI(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.publishAPI(serverName, userId, apiGUID, nullRequestBody);
    }

    @PostMapping(path={"/apis/{apiGUID}/withdraw"})
    public VoidResponse withdrawAPI(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.withdrawAPI(serverName, userId, apiGUID, nullRequestBody);
    }

    @PostMapping(path={"/apis/{apiGUID}/{qualifiedName}/delete"})
    public VoidResponse removeAPI(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiGUID, @PathVariable String qualifiedName, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeAPI(serverName, userId, apiGUID, qualifiedName, requestBody);
    }

    @PostMapping(path={"/apis/by-search-string"})
    public APIsResponse findAPIs(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findAPIs(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/apis/by-name"})
    public APIsResponse getAPIsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAPIsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/apis/api-managers/{apiManagerGUID}/{apiManagerName}"})
    public APIsResponse getAPIsForAPIManager(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiManagerGUID, @PathVariable String apiManagerName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAPIsForAPIManager(serverName, userId, apiManagerGUID, apiManagerName, startFrom, pageSize);
    }

    @GetMapping(path={"/apis/by-endpoint/{endpointGUID}"})
    public APIsResponse getAPIsByEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAPIsByEndpoint(serverName, userId, endpointGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/apis/{apiGUID}"})
    public APIResponse getAPIByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiGUID) {
        return this.restAPI.getAPIByGUID(serverName, userId, apiGUID);
    }

    @PostMapping(path={"/apis/{apiGUID}/api-operations"})
    public GUIDResponse createAPIOperation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiGUID, @RequestBody APIOperationRequestBody requestBody) {
        return this.restAPI.createAPIOperation(serverName, userId, apiGUID, requestBody);
    }

    @PostMapping(path={"/apis/{apiGUID}/api-operations/from-template/{templateGUID}"})
    public GUIDResponse createAPIOperationFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @PathVariable String apiGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createAPIOperationFromTemplate(serverName, userId, templateGUID, apiGUID, requestBody);
    }

    @PostMapping(path={"/apis/api-operations/{apiOperationGUID}"})
    public VoidResponse updateAPIOperation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiOperationGUID, @RequestParam boolean isMergeUpdate, @RequestBody APIOperationRequestBody requestBody) {
        return this.restAPI.updateAPIOperation(serverName, userId, apiOperationGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/apis/api-operations/{apiOperationGUID}/{qualifiedName}/delete"})
    public VoidResponse removeAPIOperation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiOperationGUID, @PathVariable String qualifiedName, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeAPIOperation(serverName, userId, apiOperationGUID, qualifiedName, requestBody);
    }

    @PostMapping(path={"/apis/api-operations/by-search-string"})
    public APIOperationsResponse findAPIOperations(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findAPIOperations(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/apis/{apiGUID}/api-operations"})
    public APIOperationsResponse getAPIOperationsForAPI(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAPIOperationsForAPI(serverName, userId, apiGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/apis/api-operations/by-name"})
    public APIOperationsResponse getAPIOperationsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAPIOperationsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/apis/api-operations/{apiOperationGUID}"})
    public APIOperationResponse getAPIOperationByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiOperationGUID) {
        return this.restAPI.getAPIOperationByGUID(serverName, userId, apiOperationGUID);
    }

    @PostMapping(path={"/apis/api-operations/{apiOperationGUID}/api-parameter-lists/{parameterListType}"})
    public GUIDResponse createAPIParameterList(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiOperationGUID, @PathVariable APIParameterListType parameterListType, @RequestBody APIParameterListRequestBody requestBody) {
        return this.restAPI.createAPIParameterList(serverName, userId, apiOperationGUID, parameterListType, requestBody);
    }

    @PostMapping(path={"/apis/api-operations/{apiOperationGUID}/api-parameter-lists/{parameterListType}/from-template/{templateGUID}"})
    public GUIDResponse createAPIParameterListFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @PathVariable String apiOperationGUID, @PathVariable APIParameterListType parameterListType, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createAPIParameterListFromTemplate(serverName, userId, templateGUID, apiOperationGUID, parameterListType, requestBody);
    }

    @PostMapping(path={"/apis/api-operations/api-parameter-lists/{apiParameterListGUID}"})
    public VoidResponse updateAPIParameterList(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiParameterListGUID, @RequestParam boolean isMergeUpdate, @RequestBody APIParameterListRequestBody requestBody) {
        return this.restAPI.updateAPIParameterList(serverName, userId, apiParameterListGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/apis/api-operations/api-parameter-lists/{apiParameterListGUID}/{qualifiedName}/delete"})
    public VoidResponse removeAPIParameterList(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiParameterListGUID, @PathVariable String qualifiedName, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeAPIParameterList(serverName, userId, apiParameterListGUID, qualifiedName, requestBody);
    }

    @PostMapping(path={"/apis/api-operations/api-parameter-lists/by-search-string"})
    public APIParameterListsResponse findAPIParameterLists(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findAPIParameterLists(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/apis/api-operations/{apiOperationGUID}/api-parameter-lists"})
    public APIParameterListsResponse getAPIParameterListsForOperation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiOperationGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAPIParameterListsForOperation(serverName, userId, apiOperationGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/apis/api-operations/api-parameter-lists/by-name"})
    public APIParameterListsResponse getAPIParameterListsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAPIParameterListsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/apis/api-operations/api-parameter-lists/{apiParameterListGUID}"})
    public APIParameterListResponse getAPIParameterListByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String apiParameterListGUID) {
        return this.restAPI.getAPIParameterListByGUID(serverName, userId, apiParameterListGUID);
    }
}

