/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataContainerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataContainerResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataContainersResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FormRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FormResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FormsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.QueriesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.QueryRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.QueryResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReportRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReportResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReportsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DisplayApplicationRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers such as database servers, event brokers, content managers and file systems.", externalDocs=@ExternalDocumentation(description="Data Manager Open Metadata Access Service (OMAS)", url="https://odpi.github.io/egeria-docs/services/omas/data-manager/overview/"))
public class DisplayApplicationResource {
    private DisplayApplicationRESTServices restAPI = new DisplayApplicationRESTServices();

    @PostMapping(path={"/forms"})
    public GUIDResponse createForm(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean applicationIsHome, @RequestBody FormRequestBody requestBody) {
        return this.restAPI.createForm(serverName, userId, applicationIsHome, requestBody);
    }

    @PostMapping(path={"/forms/by-template/{templateGUID}"})
    public GUIDResponse createFormFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean applicationIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createFormFromTemplate(serverName, userId, templateGUID, applicationIsHome, requestBody);
    }

    @PostMapping(path={"/forms/{formGUID}"})
    public VoidResponse updateForm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String formGUID, @RequestParam boolean isMergeUpdate, @RequestBody FormRequestBody requestBody) {
        return this.restAPI.updateForm(serverName, userId, formGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/forms/{formGUID}/publish"})
    public VoidResponse publishForm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String formGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.publishForm(serverName, userId, formGUID, nullRequestBody);
    }

    @PostMapping(path={"/forms/{formGUID}/withdraw"})
    public VoidResponse withdrawForm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String formGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.withdrawForm(serverName, userId, formGUID, nullRequestBody);
    }

    @PostMapping(path={"/forms/{formGUID}/{qualifiedName}/delete"})
    public VoidResponse removeForm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String formGUID, @PathVariable String qualifiedName, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeForm(serverName, userId, formGUID, qualifiedName, requestBody);
    }

    @PostMapping(path={"/forms/by-search-string"})
    public FormsResponse findForms(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findForms(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/forms/by-name"})
    public FormsResponse getFormsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getFormsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/forms/applications/{applicationGUID}/{applicationName}"})
    public FormsResponse getFormsForApplication(@PathVariable String serverName, @PathVariable String userId, @PathVariable String applicationGUID, @PathVariable String applicationName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getFormsForApplication(serverName, userId, applicationGUID, applicationName, startFrom, pageSize);
    }

    @GetMapping(path={"/forms/{formGUID}"})
    public FormResponse getFormByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String formGUID) {
        return this.restAPI.getFormByGUID(serverName, userId, formGUID);
    }

    @PostMapping(path={"/reports"})
    public GUIDResponse createReport(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean applicationIsHome, @RequestBody ReportRequestBody requestBody) {
        return this.restAPI.createReport(serverName, userId, applicationIsHome, requestBody);
    }

    @PostMapping(path={"/reports/from-template/{templateGUID}"})
    public GUIDResponse createReportFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean applicationIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createReportFromTemplate(serverName, userId, templateGUID, applicationIsHome, requestBody);
    }

    @PostMapping(path={"/reports/{reportGUID}"})
    public VoidResponse updateReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String reportGUID, @RequestParam boolean isMergeUpdate, @RequestBody ReportRequestBody requestBody) {
        return this.restAPI.updateReport(serverName, userId, reportGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/reports/{reportGUID}/publish"})
    public VoidResponse publishReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String reportGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.publishReport(serverName, userId, reportGUID, nullRequestBody);
    }

    @PostMapping(path={"/reports/{reportGUID}/withdraw"})
    public VoidResponse withdrawReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String reportGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.withdrawReport(serverName, userId, reportGUID, nullRequestBody);
    }

    @PostMapping(path={"/reports/{reportGUID}/{qualifiedName}/delete"})
    public VoidResponse removeReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String reportGUID, @PathVariable String qualifiedName, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeReport(serverName, userId, reportGUID, qualifiedName, requestBody);
    }

    @PostMapping(path={"/reports/by-search-string"})
    public ReportsResponse findReports(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findReports(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/reports/by-name"})
    public ReportsResponse getReportsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getReportsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/reports/applications/{applicationGUID}/{applicationName}"})
    public ReportsResponse getReportsForApplication(@PathVariable String serverName, @PathVariable String userId, @PathVariable String applicationGUID, @PathVariable String applicationName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getReportsForApplication(serverName, userId, applicationGUID, applicationName, startFrom, pageSize);
    }

    @GetMapping(path={"/reports/{reportGUID}"})
    public ReportResponse getReportByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String reportGUID) {
        return this.restAPI.getReportByGUID(serverName, userId, reportGUID);
    }

    @PostMapping(path={"/queries"})
    public GUIDResponse createQuery(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean applicationIsHome, @RequestBody QueryRequestBody requestBody) {
        return this.restAPI.createQuery(serverName, userId, applicationIsHome, requestBody);
    }

    @PostMapping(path={"/queries/from-template/{templateGUID}"})
    public GUIDResponse createQueryFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean applicationIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createQueryFromTemplate(serverName, userId, templateGUID, applicationIsHome, requestBody);
    }

    @PostMapping(path={"/queries/{queryGUID}"})
    public VoidResponse updateQuery(@PathVariable String serverName, @PathVariable String userId, @PathVariable String queryGUID, @RequestParam boolean isMergeUpdate, @RequestBody QueryRequestBody requestBody) {
        return this.restAPI.updateQuery(serverName, userId, queryGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/queries/{queryGUID}/publish"})
    public VoidResponse publishQuery(@PathVariable String serverName, @PathVariable String userId, @PathVariable String queryGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.publishQuery(serverName, userId, queryGUID, nullRequestBody);
    }

    @PostMapping(path={"/queries/{queryGUID}/withdraw"})
    public VoidResponse withdrawQuery(@PathVariable String serverName, @PathVariable String userId, @PathVariable String queryGUID, @RequestBody(required=false) NullRequestBody nullRequestBody) {
        return this.restAPI.withdrawQuery(serverName, userId, queryGUID, nullRequestBody);
    }

    @PostMapping(path={"/queries/{queryGUID}/{qualifiedName}/delete"})
    public VoidResponse removeQuery(@PathVariable String serverName, @PathVariable String userId, @PathVariable String queryGUID, @PathVariable String qualifiedName, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeQuery(serverName, userId, queryGUID, qualifiedName, requestBody);
    }

    @PostMapping(path={"/queries/by-search-string"})
    public QueriesResponse findQueries(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findQueries(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/queries/by-name"})
    public QueriesResponse getQueriesByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getQueriesByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/queries/applications/{applicationGUID}/{applicationName}"})
    public QueriesResponse getQueriesForApplication(@PathVariable String serverName, @PathVariable String userId, @PathVariable String applicationGUID, @PathVariable String applicationName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getQueriesForApplication(serverName, userId, applicationGUID, applicationName, startFrom, pageSize);
    }

    @GetMapping(path={"/queries/{queryGUID}"})
    public QueryResponse getQueryByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String queryGUID) {
        return this.restAPI.getQueryByGUID(serverName, userId, queryGUID);
    }

    @PostMapping(path={"/elements/{parentGUID}/data-containers"})
    public GUIDResponse createDataContainer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentGUID, @RequestParam boolean applicationIsHome, @RequestBody DataContainerRequestBody requestBody) {
        return this.restAPI.createDataContainer(serverName, userId, parentGUID, applicationIsHome, requestBody);
    }

    @PostMapping(path={"/elements/{parentGUID}/data-containers/from-template/{templateGUID}"})
    public GUIDResponse createDataContainerFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @PathVariable String parentGUID, @RequestParam boolean applicationIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createDataContainerFromTemplate(serverName, userId, templateGUID, parentGUID, applicationIsHome, requestBody);
    }

    @PostMapping(path={"/data-containers/{dataContainerGUID}"})
    public VoidResponse updateDataContainer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataContainerGUID, @RequestParam boolean isMergeUpdate, @RequestBody DataContainerRequestBody requestBody) {
        return this.restAPI.updateDataContainer(serverName, userId, dataContainerGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/data-containers/{dataContainerGUID}/delete"})
    public VoidResponse removeDataContainer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataContainerGUID, @PathVariable String qualifiedName, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeDataContainer(serverName, userId, dataContainerGUID, qualifiedName, requestBody);
    }

    @PostMapping(path={"/data-containers/by-search-string"})
    public DataContainersResponse findDataContainers(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDataContainers(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/data-containers/by-parent-element/{parentGUID}"})
    public DataContainersResponse getDataContainersForParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDataContainersForParent(serverName, userId, parentGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/data-containers/by-name"})
    public DataContainersResponse getDataContainersByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDataContainersByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/data-containers/{dataContainerGUID}"})
    public DataContainerResponse getDataContainerByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataContainerGUID) {
        return this.restAPI.getDataContainerByGUID(serverName, userId, dataContainerGUID);
    }
}

