/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemaResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemasResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTableResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTablesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabasesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DatabaseManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Metadata Access Server: Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers such as database servers, event brokers, content managers and file systems.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/data-manager/overview/"))
public class DatabaseManagerResource {
    private final DatabaseManagerRESTServices restAPI = new DatabaseManagerRESTServices();

    @PostMapping(path={"/databases"})
    public GUIDResponse createDatabase(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createDatabase(serverName, userId, requestBody);
    }

    @PostMapping(path={"/databases/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createDatabaseFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/databases/{databaseGUID}"})
    public VoidResponse updateDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseGUID, @RequestParam(required=false) boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateDatabase(serverName, userId, databaseGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/databases/{databaseGUID}/publish"})
    public VoidResponse publishDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseGUID, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.publishDatabase(serverName, userId, databaseGUID, requestBody);
    }

    @PostMapping(path={"/databases/{databaseGUID}/withdraw"})
    public VoidResponse withdrawDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseGUID, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.withdrawDatabase(serverName, userId, databaseGUID, requestBody);
    }

    @PostMapping(path={"/databases/{databaseGUID}/delete"})
    public VoidResponse removeDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeDatabase(serverName, userId, databaseGUID, requestBody);
    }

    @PostMapping(path={"/databases/by-search-string"})
    public DatabasesResponse findDatabases(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabases(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/databases/by-name"})
    public DatabasesResponse getDatabasesByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabasesByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/database-managers/{databaseManagerGUID}/{databaseManagerName}/databases"})
    public DatabasesResponse getDatabasesForDatabaseManager(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseManagerGUID, @PathVariable String databaseManagerName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabasesForDatabaseManager(serverName, userId, databaseManagerGUID, databaseManagerName, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/{guid}"})
    public DatabaseResponse getDatabaseByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/databases/schemas"})
    public GUIDResponse createDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createDatabaseSchema(serverName, userId, requestBody);
    }

    @PostMapping(path={"/databases/schemas/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseSchemaFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createDatabaseSchemaFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/databases/schemas/{databaseSchemaGUID}"})
    public VoidResponse updateDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseSchemaGUID, @RequestParam(required=false) boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateDatabaseSchema(serverName, userId, databaseSchemaGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/databases/schemas/{databaseSchemaGUID}/publish"})
    public VoidResponse publishDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseSchemaGUID, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.publishDatabaseSchema(serverName, userId, databaseSchemaGUID, requestBody);
    }

    @PostMapping(path={"/databases/schemas/{databaseSchemaGUID}/withdraw"})
    public VoidResponse withdrawDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseSchemaGUID, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.withdrawDatabase(serverName, userId, databaseSchemaGUID, requestBody);
    }

    @PostMapping(path={"/databases/schemas/{databaseSchemaGUID}/delete"})
    public VoidResponse removeDatabaseSchema(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseSchemaGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeDatabaseSchema(serverName, userId, databaseSchemaGUID, requestBody);
    }

    @PostMapping(path={"/databases/schemas/by-search-string"})
    public DatabaseSchemasResponse findDatabaseSchemas(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabaseSchemas(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/{databaseGUID}/schemas"})
    public DatabaseSchemasResponse getSchemasForDatabase(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSchemasForDatabase(serverName, userId, databaseGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/databases/schemas/by-name"})
    public DatabaseSchemasResponse getDatabaseSchemasByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabaseSchemasByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/schemas/{guid}"})
    public DatabaseSchemaResponse getDatabaseSchemaByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseSchemaByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/databases/schema-type"})
    public GUIDResponse createDatabaseSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createDatabaseSchemaType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/databases/{databaseAssetGUID}/schema-type/{schemaTypeGUID}"})
    public VoidResponse attachSchemaTypeToDatabaseAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseAssetGUID, @PathVariable String schemaTypeGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.attachSchemaTypeToDatabaseAsset(serverName, userId, databaseAssetGUID, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/databases/tables"})
    public GUIDResponse createDatabaseTable(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createDatabaseTable(serverName, userId, requestBody);
    }

    @PostMapping(path={"/databases/tables/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseTableFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createDatabaseTableFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/databases/schema-type/tables"})
    public GUIDResponse createDatabaseTableForSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createDatabaseTableForSchemaType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/databases/tables/{databaseTableGUID}"})
    public VoidResponse updateDatabaseTable(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseTableGUID, @RequestParam(required=false) boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateDatabaseTable(serverName, userId, databaseTableGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/databases/tables/{databaseTableGUID}/delete"})
    public VoidResponse removeDatabaseTable(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseTableGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeDatabaseTable(serverName, userId, databaseTableGUID, requestBody);
    }

    @PostMapping(path={"/databases/tables/by-search-string"})
    public DatabaseTablesResponse findDatabaseTables(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabaseTables(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/{databaseAssetGUID}/tables"})
    public DatabaseTablesResponse getTablesForDatabaseAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseAssetGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getTablesForDatabaseAsset(serverName, userId, databaseAssetGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/databases/tables/by-name"})
    public DatabaseTablesResponse getDatabaseTablesByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabaseTablesByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/tables/{guid}"})
    public DatabaseTableResponse getDatabaseTableByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseTableByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/databases/tables/views"})
    public GUIDResponse createDatabaseView(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createDatabaseView(serverName, userId, requestBody);
    }

    @PostMapping(path={"/databases/tables/views/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseViewFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createDatabaseViewFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/databases/schema-type/tables/views"})
    public GUIDResponse createDatabaseViewForSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createDatabaseViewForSchemaType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/databases/tables/views/{databaseViewGUID}"})
    public VoidResponse updateDatabaseView(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseViewGUID, @RequestParam(required=false) boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateDatabaseView(serverName, userId, databaseViewGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/databases/tables/views/{databaseViewGUID}/delete"})
    public VoidResponse removeDatabaseView(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseViewGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeDatabaseView(serverName, userId, databaseViewGUID, requestBody);
    }

    @PostMapping(path={"/databases/tables/views/by-search-string"})
    public DatabaseViewsResponse findDatabaseViews(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabaseViews(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/{databaseAssetGUID}/tables/views"})
    public DatabaseViewsResponse getViewsForDatabaseAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseAssetGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getViewsForDatabaseAsset(serverName, userId, databaseAssetGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/databases/tables/views/by-name"})
    public DatabaseViewsResponse getDatabaseViewsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabaseViewsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/tables/views/{guid}"})
    public DatabaseViewResponse getDatabaseViewByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseViewByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/databases/tables/columns"})
    public GUIDResponse createDatabaseColumn(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createDatabaseColumn(serverName, userId, requestBody);
    }

    @PostMapping(path={"/databases/tables/columns/from-template/{templateGUID}"})
    public GUIDResponse createDatabaseColumnFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createDatabaseColumnFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/databases/tables/columns/{databaseColumnGUID}"})
    public VoidResponse updateDatabaseColumn(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseColumnGUID, @RequestParam(required=false) boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateDatabaseColumn(serverName, userId, databaseColumnGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/databases/tables/columns/{databaseColumnGUID}/delete"})
    public VoidResponse removeDatabaseColumn(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseColumnGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeDatabaseColumn(serverName, userId, databaseColumnGUID, requestBody);
    }

    @PostMapping(path={"/databases/tables/columns/by-search-string"})
    public DatabaseColumnsResponse findDatabaseColumns(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findDatabaseColumns(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/tables/{databaseTableGUID}/columns"})
    public DatabaseColumnsResponse getColumnsForDatabaseTable(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseTableGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getColumnsForDatabaseTable(serverName, userId, databaseTableGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/databases/tables/columns/by-name"})
    public DatabaseColumnsResponse getDatabaseColumnsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDatabaseColumnsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/databases/tables/columns/{guid}"})
    public DatabaseColumnResponse getDatabaseColumnByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDatabaseColumnByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/databases/tables/columns/{databaseColumnGUID}/primary-key"})
    public VoidResponse setPrimaryKeyOnColumn(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseColumnGUID, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setPrimaryKeyOnColumn(serverName, userId, databaseColumnGUID, requestBody);
    }

    @PostMapping(path={"/databases/tables/columns/{databaseColumnGUID}/primary-key/delete"})
    public VoidResponse removePrimaryKeyFromColumn(@PathVariable String serverName, @PathVariable String userId, @PathVariable String databaseColumnGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removePrimaryKeyFromColumn(serverName, userId, databaseColumnGUID, requestBody);
    }

    @PostMapping(path={"/databases/tables/columns/{foreignKeyColumnGUID}/foreign-key/{primaryKeyColumnGUID}"})
    public VoidResponse addForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String primaryKeyColumnGUID, @PathVariable String foreignKeyColumnGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.addForeignKeyRelationship(serverName, userId, primaryKeyColumnGUID, foreignKeyColumnGUID, requestBody);
    }

    @PostMapping(path={"/databases/tables/columns/{foreignKeyColumnGUID}/foreign-key/{primaryKeyColumnGUID}/delete"})
    public VoidResponse removeForeignKeyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String primaryKeyColumnGUID, @PathVariable String foreignKeyColumnGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeForeignKeyRelationship(serverName, userId, primaryKeyColumnGUID, foreignKeyColumnGUID, requestBody);
    }
}

