/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.datamanager.server.ValidValuesRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValueResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValuesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-manager/users/{userId}"})
@Tag(name="Metadata Access Server: Data Manager OMAS", description="The Data Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to data managers such as database servers, event brokers, content managers and file systems.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/data-manager/overview/"))
public class DataManagerValidValuesResource {
    private final ValidValuesRESTServices restAPI = new ValidValuesRESTServices();

    @PostMapping(path={"/valid-values"})
    public GUIDResponse createValidValue(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createValidValue(serverName, userId, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}"})
    public VoidResponse updateValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateValidValue(serverName, userId, validValueGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueSetGUID}/valid-value-members/{validValueMemberGUID}"})
    public VoidResponse setupValidValueMember(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueSetGUID, @PathVariable String validValueMemberGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupValidValueMember(serverName, userId, validValueSetGUID, validValueMemberGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueSetGUID}/valid-value-members/{validValueMemberGUID}/delete"})
    public VoidResponse clearValidValueMember(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueSetGUID, @PathVariable String validValueMemberGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearValidValueMember(serverName, userId, validValueSetGUID, validValueMemberGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{elementGUID}/valid-values/{validValueGUID}"})
    public VoidResponse setupValidValues(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String validValueGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupValidValues(serverName, userId, elementGUID, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{elementGUID}/valid-values/{validValueGUID}/delete"})
    public VoidResponse clearValidValues(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String validValueGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearValidValues(serverName, userId, elementGUID, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{elementGUID}/reference-value-tags/{validValueGUID}"})
    public VoidResponse setupReferenceValueTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String validValueGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupReferenceValueTag(serverName, userId, elementGUID, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{elementGUID}/reference-value-tags/{validValueGUID}/delete"})
    public VoidResponse clearReferenceValueTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String validValueGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearReferenceValueTag(serverName, userId, elementGUID, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/delete"})
    public VoidResponse removeValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeValidValue(serverName, userId, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/by-search-string"})
    public ValidValuesResponse findValidValues(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findValidValues(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/valid-values/by-name"})
    public ValidValuesResponse getValidValuesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getValidValuesByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/members/{validValueSetGUID}"})
    public ValidValuesResponse getValidValueSetMembers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueSetGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValueSetMembers(serverName, userId, validValueSetGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/sets/{validValueGUID}"})
    public ValidValuesResponse getSetsForValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSetsForValidValue(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/by-consumer/{elementGUID}"})
    public ValidValueResponse getValidValuesForConsumer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID) {
        return this.restAPI.getValidValuesForConsumer(serverName, userId, elementGUID);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/consumers"})
    public RelatedElementsResponse getConsumersOfValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getConsumersOfValidValue(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/by-reference-value-tags/{elementGUID}"})
    public ValidValuesResponse getReferenceValues(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getReferenceValues(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/by-reference-value-tag-assignees"})
    public RelatedElementsResponse getAssigneesOfReferenceValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssigneesOfReferenceValue(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values"})
    public ValidValuesResponse getAllValidValues(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAllValidValues(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{guid}"})
    public ValidValueResponse getValidValueByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getValidValueByGUID(serverName, userId, guid);
    }
}

