/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.connectors.outtopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEvent;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerAuditCode;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicSenderConnectorBase;

public class DataManagerOutTopicServerConnector
extends OpenMetadataTopicSenderConnectorBase {
    public void sendEvent(DataManagerOutboundEvent event) throws InvalidParameterException, ConnectorCheckedException {
        String methodName = "sendEvent";
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String eventString = objectMapper.writeValueAsString((Object)event);
            super.sendEvent(eventString);
            if (this.auditLog != null) {
                this.auditLog.logMessage("sendEvent", DataManagerAuditCode.OUT_TOPIC_EVENT.getMessageDefinition(new String[]{eventString}));
            }
        }
        catch (ConnectorCheckedException | InvalidParameterException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(DataManagerErrorCode.UNABLE_TO_SEND_EVENT.getMessageDefinition(new String[]{this.connectionName, event.toString(), error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "sendEvent", (Throwable)error);
        }
    }
}

