/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.dataofficer.admin;

import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.ViewServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.dataofficer.ffdc.DataOfficerAuditCode;
import org.odpi.openmetadata.viewservices.dataofficer.server.DataOfficerInstance;

public class DataOfficerAdmin
extends ViewServiceAdmin {
    private AuditLog auditLog = null;
    private DataOfficerInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfig, AuditLog auditLog, String serverUserName, int maxPageSize) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", DataOfficerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        this.serverName = serverName;
        try {
            this.instance = new DataOfficerInstance(serverName, auditLog, serverUserName, maxPageSize, viewServiceConfig.getOMAGServerName(), viewServiceConfig.getOMAGServerPlatformRootURL());
            auditLog.logMessage("initialize", DataOfficerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(), viewServiceConfig.toString());
        }
        catch (Exception error) {
            auditLog.logException("initialize", DataOfficerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(error.getMessage()), viewServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", ViewServiceDescription.DATA_OFFICER.getViewServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", DataOfficerAuditCode.SERVICE_TERMINATING.getMessageDefinition(this.serverName));
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", DataOfficerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.serverName));
    }
}

