/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DataPlatformEventType implements Serializable
{
    UNKNOWN_DATA_PLATFORM_EVENT(0, "Unknown Event", "An event that is not recognized by the local server."),
    NEW_ASSET_EVENT(1, "New Asset", "A new asset has been added to one of the access point zones."),
    UPDATED_ASSET_EVENT(2, "Updated Asset", "An existing asset has been updated or added to one of the access point zones."),
    NEW_RELATIONSHIP_EVENT(3, "New Relationship", "An new relationship has been assigned between entities."),
    NEW_INFORMATION_VIEW_EVENT(4, "New Information View Asset", "An new information view asset has been added to one of the access point zones."),
    NEW_DEPLOYED_DB_SCHEMA_EVENT(5, "New Deployed Database Schema Asset", "An new deployed database schema asset has been added to one of the access point zones. ");

    private static final long serialVersionUID = 1L;
    private int eventTypeCode;
    private String eventTypeName;
    private String eventTypeDescription;

    private DataPlatformEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }

    public String toString() {
        return "AssetConsumerEventType{eventTypeCode=" + this.eventTypeCode + ", eventTypeName='" + this.eventTypeName + '\'' + ", eventTypeDescription='" + this.eventTypeDescription + '\'' + '}';
    }
}

