/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum DataPlatformAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-DATA-PLATFORM-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Data Platform Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Data Platform OMAS.  This service supports the exchange of metadata between data platforms.", "No action is required if the Data Platform OMAS service is expected to be started in this server.  If this service is not required then it can be removed from the access service list in the configuration document for this server.  It will then not be started the next time the server starts up."),
    SERVICE_PUBLISHING("OMAS-DATA-PLATFORM-0002", OMRSAuditLogRecordSeverity.STARTUP, "The Data Platform Open Metadata Access Service (OMAS) is ready to publish data platform notifications to topic {0}", "The local server has started up the event publisher for the Data Platform OMAS.  It will begin publishing data platform metadata changes to its out topic.", "This is part of the normal start up of the service. Check that there are no errors from the event bus."),
    SERVICE_INITIALIZED("OMAS-DATA-PLATFORM-0005", OMRSAuditLogRecordSeverity.STARTUP, "The Data Platform Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The Data Platform OMAS has completed initialization of a new instance.", "Verify that this service has initialized successfully with both an in and out topic and it has the correct set of supported zones, publish zones and default zones defined.  Investigate any reported errors.  Also ensure that theenterprise repository services and the OCF metadata management services are initialized."),
    SERVICE_SHUTDOWN("OMAS-DATA-PLATFORM-0006", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Data Platform Open Metadata Access Service (OMAS) is shutting down server instance {0}", "The local server has requested shut down of an Data Platform OMAS server instance.", "No action is required if this shutdown was intended."),
    PUBLISHING_SHUTDOWN("OMAS-DATA-PLATFORM-0007", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Data Platform Open Metadata Access Service (OMAS) is no longer publishing events to topic {0}", "The local administrator has requested shut down of an Data Platform OMAS instance.  No more events will be published to the named topic.", "This is part of the normal shutdown of the service.   No action is required if this is serviceshutdown was intentional."),
    PUBLISHING_SHUTDOWN_ERROR("OMAS-DATA-PLATFORM-0008", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Data Platform Open Metadata Access Service (OMAS) caught an unexpected {0} exception whilst shutting down the out topic {1}. The error message was: {2}", "The local administrator has requested shut down of an Data Platform OMAS instance.  No more events will be published to the named topic, although the connection to the event bus may not be released properly.", "This is part of the normal shutdown of the service. However, an exception is not expected at this point unless it is the consequence of a previous error. Review the error message and any other reported failures to determine if this exception needs special attention."),
    SERVICE_INSTANCE_FAILURE("OMAS-DATA-PLATFORM-0011", OMRSAuditLogRecordSeverity.EXCEPTION, "The Data Platform Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_INSTANCE_TERMINATION_FAILURE("OMAS-DATA-PLATFORM-0012", OMRSAuditLogRecordSeverity.EXCEPTION, "The Data Platform Open Metadata Access Service (OMAS) is unable to terminate a new instance; error message is {0}", "The access service detected an error during the shut down of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, try to shut down the server."),
    OUT_TOPIC_EVENT("OMAS-DATA-PLATFORM-0013", OMRSAuditLogRecordSeverity.EVENT, "The Data Platform Open Metadata Access Service (OMAS) has sent event: {0}", "The access service sends out notifications about changes to assets located on data platforms.  This message is to create a record of the events that are being published.", "This event indicates that one of the assets within a data platform has changed."),
    PROCESS_EVENT_EXCEPTION("OMAS-DATA-PLATFORM-0014", OMRSAuditLogRecordSeverity.EXCEPTION, "Event {0} could not be consumed. Error: {1}", "The system is unable to process the request.", "Verify the topic configuration."),
    PARSE_EVENT_EXCEPTION("OMAS-DATA-PLATFORM-0015", OMRSAuditLogRecordSeverity.EXCEPTION, "Inbound event {0} could not be parsed. IOException included the following message: {1}", "The system is unable to process the event received on the Data Platform OMAS in topic.", "Verify the content and structure of the in topic event.  Check that it includes the correct class name key");

    private static final long serialVersionUID = 1L;
    private AuditLogMessageDefinition messageDefinition;

    private DataPlatformAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "DataPlatformAuditCode{messageDefinition=" + this.messageDefinition + '}';
    }
}

