/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.client;

import org.odpi.openmetadata.accessservices.dataplatform.DataPlatformInterface;
import org.odpi.openmetadata.accessservices.dataplatform.properties.DeployedDatabaseSchema;
import org.odpi.openmetadata.accessservices.dataplatform.properties.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataplatform.responses.DataPlatformRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataplatform.responses.DeployedDatabaseSchemaRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DataPlatformClient
extends OCFRESTClient
implements DataPlatformInterface {
    private static final String QUALIFIED_NAME_PARAMETER = "qualifiedName";
    private static final String DATA_PLATFORM_REGISTRATION_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-platform/users/{1}/registration";
    private static final String DEPLOYED_DATABASE_SCHEMA_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-platform/users/{1}/deployed-database-schema";
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public DataPlatformClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
    }

    public DataPlatformClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
    }

    @Override
    public GUIDResponse createExternalDataPlatform(String userId, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalDataPlatform";
        this.invalidParameterHandler.validateUserId(userId, "createExternalDataPlatform");
        DataPlatformRegistrationRequestBody requestBody = new DataPlatformRegistrationRequestBody();
        requestBody.setSoftwareServerCapability(softwareServerCapability);
        return this.callGUIDPostRESTCall(userId, "createExternalDataPlatform", DATA_PLATFORM_REGISTRATION_URL_TEMPLATE, new Object[]{requestBody});
    }

    @Override
    public GUIDResponse createDeployedDatabaseSchema(String userId, DeployedDatabaseSchema deployedDatabaseSchema) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDeployedDatabaseSchema";
        this.invalidParameterHandler.validateUserId(userId, "createDeployedDatabaseSchema");
        DeployedDatabaseSchemaRequestBody requestBody = new DeployedDatabaseSchemaRequestBody();
        requestBody.setDeployedDatabaseSchema(deployedDatabaseSchema);
        return this.callGUIDPostRESTCall(userId, "createDeployedDatabaseSchema", DEPLOYED_DATABASE_SCHEMA_URL_TEMPLATE, new Object[]{requestBody});
    }
}

