/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.handlers;

import org.odpi.openmetadata.accessservices.dataplatform.events.NewDeployedDatabaseSchemaEvent;
import org.odpi.openmetadata.accessservices.dataplatform.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataplatform.utils.QualifiedNameUtils;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DeployedDatabaseSchemaAssetHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;

    public DeployedDatabaseSchemaAssetHandler(String serviceName, String serverName, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.invalidParameterHandler = invalidParameterHandler;
    }

    public void createDeployedDatabaseSchemaAsset(NewDeployedDatabaseSchemaEvent event) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String methodName = "create Deployed Database Schema Asset";
        String qualifiedNameForSoftwareServer = QualifiedNameUtils.buildQualifiedName("", "SoftwareServer", event.getDataPlatform().getDataPlatformEndpoint().getDisplayName() + event.getDataPlatform().getDataPlatformEndpoint().getAddress().split(":")[0]);
        this.invalidParameterHandler.validateUserId("dataPlatformOmas", methodName);
        this.invalidParameterHandler.validateName(qualifiedNameForSoftwareServer, "qualifiedName", methodName);
        InstanceProperties softwareServerProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForSoftwareServer).withStringProperty("name", qualifiedNameForSoftwareServer).build();
        String softwareServerEntityGuid = this.repositoryHandler.createEntity("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "SoftwareServer").getGUID(), "SoftwareServer", softwareServerProperties, methodName);
        String qualifiedNameForEndpoint = QualifiedNameUtils.buildQualifiedName("", "Endpoint", event.getDataPlatform().getDataPlatformEndpoint().getEncryptionMethod() + event.getDataPlatform().getDataPlatformEndpoint().getAddress());
        InstanceProperties endpointProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForEndpoint).withStringProperty("name", qualifiedNameForEndpoint).withStringProperty("networkAddress", event.getDataPlatform().getDataPlatformEndpoint().getAddress()).withStringProperty("protocol", event.getDataPlatform().getDataPlatformEndpoint().getProtocol()).build();
        this.invalidParameterHandler.validateName(qualifiedNameForEndpoint, "qualifiedName", methodName);
        String endpointEntityGuid = this.repositoryHandler.createEntity("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "Endpoint").getGUID(), "Endpoint", endpointProperties, methodName);
        this.repositoryHandler.createRelationship("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "ServerEndpoint").getGUID(), softwareServerEntityGuid, endpointEntityGuid, new InstanceProperties(), methodName);
        String qualifiedNameForConnection = QualifiedNameUtils.buildQualifiedName(qualifiedNameForEndpoint, "Connection", event.getDataPlatform().getDataPlatformEndpoint().getDisplayName());
        InstanceProperties connectionProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForConnection).withStringProperty("description", "Connection to " + qualifiedNameForConnection).build();
        this.invalidParameterHandler.validateName(qualifiedNameForConnection, "qualifiedName", methodName);
        String connectionEntityGuid = this.repositoryHandler.createEntity("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "Connection").getGUID(), "Connection", connectionProperties, methodName);
        this.repositoryHandler.createRelationship("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "ConnectionEndpoint").getGUID(), endpointEntityGuid, connectionEntityGuid, new InstanceProperties(), methodName);
        String qualifiedNameForConnectorType = QualifiedNameUtils.buildQualifiedName("", "ConnectorType", ((ConnectorType)event.getDataPlatform().getDataPlatformConnectorType().get(0)).getConnectorProviderClassName());
        InstanceProperties connectorTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForConnectorType).withStringProperty("connectorProviderClassName", ((ConnectorType)event.getDataPlatform().getDataPlatformConnectorType().get(0)).getConnectorProviderClassName()).build();
        this.invalidParameterHandler.validateName(qualifiedNameForConnectorType, "qualifiedName", methodName);
        String connectorTypeEntityGuid = this.repositoryHandler.createEntity("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "ConnectorType").getGUID(), "ConnectorType", connectorTypeProperties, methodName);
        this.repositoryHandler.createRelationship("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "ConnectionConnectorType").getGUID(), connectionEntityGuid, connectorTypeEntityGuid, new InstanceProperties(), methodName);
        String qualifiedNameForDatabase = QualifiedNameUtils.buildQualifiedName(qualifiedNameForSoftwareServer, "Database", "Apache Cassandra Data Store");
        InstanceProperties databaseProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForDatabase).withStringProperty("name", "Apache Cassandra Data Store").build();
        this.invalidParameterHandler.validateName(qualifiedNameForDatabase, "qualifiedName", methodName);
        String databaseEntityGuid = this.repositoryHandler.createEntity("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "Database").getGUID(), "Database", databaseProperties, methodName);
        String qualifiedNameForDeployedDatabaseSchema = QualifiedNameUtils.buildQualifiedName(qualifiedNameForDatabase, "DeployedDatabaseSchema", event.getKeyspace().getKeyspaceName());
        InstanceProperties deployedDbSchemaProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForDeployedDatabaseSchema).withStringProperty("name", event.getKeyspace().getKeyspaceName()).withStringProperty("owner", "Owner Info").withStringProperty("description", "Description").build();
        this.invalidParameterHandler.validateName(qualifiedNameForDeployedDatabaseSchema, "qualifiedName", methodName);
        String deployedDbSchemaEntityGuid = this.repositoryHandler.createEntity("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "DeployedDatabaseSchema").getGUID(), "DeployedDatabaseSchema", deployedDbSchemaProperties, methodName);
        this.repositoryHandler.createRelationship("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "DataContentForDataSet").getGUID(), databaseEntityGuid, deployedDbSchemaEntityGuid, new InstanceProperties(), methodName);
        this.repositoryHandler.createRelationship("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "ConnectionToAsset").getGUID(), connectionEntityGuid, deployedDbSchemaEntityGuid, new InstanceProperties(), methodName);
    }
}

