/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.dataplatform.beans.View;
import org.odpi.openmetadata.accessservices.dataplatform.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.dataplatform.contentmanager.OMEntityWrapper;
import org.odpi.openmetadata.accessservices.dataplatform.events.NewViewEvent;
import org.odpi.openmetadata.accessservices.dataplatform.properties.BusinessTerm;
import org.odpi.openmetadata.accessservices.dataplatform.properties.DerivedColumn;
import org.odpi.openmetadata.accessservices.dataplatform.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataplatform.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewHandler
implements Callable<View> {
    private static final Logger log = LoggerFactory.getLogger(ViewHandler.class);
    private NewViewEvent event;
    private OMEntityDao omEntityDao;
    private OMRSRepositoryHelper helper;

    public ViewHandler(NewViewEvent event, OMEntityDao omEntityDao, OMRSRepositoryHelper helper) {
        this.event = event;
        this.omEntityDao = omEntityDao;
        this.helper = helper;
    }

    @Override
    public View call() throws Exception {
        View view = new View();
        if (this.event.getDerivedColumns() == null || this.event.getDerivedColumns().isEmpty()) {
            log.info("Delete existing view as event received has no derived columns");
            this.deleteView(this.event);
        } else {
            String qualifiedNameForInformationView = QualifiedNameUtils.buildQualifiedNameForInformationView(this.event.getTableSource().getDatabaseSource().getEndpointSource().getNetworkAddress().split(":")[0], this.event.getTableSource().getDatabaseSource().getName(), this.event.getTableSource().getSchemaName());
            String qualifiedNameForTableType = QualifiedNameUtils.buildQualifiedName(qualifiedNameForInformationView, "RelationalTableType", this.event.getTableSource().getName() + "_type");
            InstanceProperties tableTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForTableType).withStringProperty("displayName", this.event.getTableSource().getName() + "_type").withStringProperty("author", "").withStringProperty("usage", "").withStringProperty("encodingStandard", "").build();
            OMEntityWrapper tableTypeEntityWrapper = this.omEntityDao.createOrUpdateEntity("RelationalTableType", qualifiedNameForTableType, tableTypeProperties, null, false, false);
            String qualifiedNameForTable = QualifiedNameUtils.buildQualifiedName(qualifiedNameForInformationView, "RelationalTable", this.event.getTableSource().getName());
            InstanceProperties tableProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForTable).withStringProperty("name", this.event.getTableSource().getName()).build();
            if (this.event.getOriginalTableSource() != null) {
                HashMap<String, String> prop = new HashMap<String, String>();
                prop.put("displayName", this.event.getOriginalTableSource().getName());
                tableProperties = this.helper.addStringMapPropertyToInstance("DataPlatformOmas", tableProperties, "additionalProperties", prop, "ViewHandler.call");
            }
            EntityDetail tableEntity = this.omEntityDao.addEntity("RelationalTable", qualifiedNameForTable, tableProperties, false);
            view.setViewEntity(tableEntity);
            EntityDetail tableTypeEntity = tableTypeEntityWrapper.getEntityDetail();
            this.addRelationship(tableEntity.getGUID(), tableTypeEntity.getGUID(), "SchemaAttributeType");
            List<Object> columnsToBeDeleted = null;
            if (this.entityIsNotNew(tableTypeEntityWrapper)) {
                columnsToBeDeleted = this.omEntityDao.getRelationships("AttributeForSchema", tableTypeEntity.getGUID());
            }
            if (this.event.getDerivedColumns() != null && !this.event.getDerivedColumns().isEmpty()) {
                List derivedColumns = this.event.getDerivedColumns().parallelStream().map(c -> this.addDerivedColumn(tableTypeEntity, qualifiedNameForTable, (DerivedColumn)c)).collect(Collectors.toList());
                List newDerivedColumnsGuids = derivedColumns.stream().map(e -> e.getGUID()).collect(Collectors.toList());
                if (columnsToBeDeleted != null && !columnsToBeDeleted.isEmpty()) {
                    columnsToBeDeleted = columnsToBeDeleted.stream().filter(c -> !newDerivedColumnsGuids.contains(c.getEntityTwoProxy().getGUID())).collect(Collectors.toList());
                }
            }
            this.deleteColumns(columnsToBeDeleted);
        }
        return view;
    }

    private boolean entityIsNotNew(OMEntityWrapper tableTypeEntityWrapper) {
        return OMEntityWrapper.EntityStatus.EXISTING.equals((Object)tableTypeEntityWrapper.getEntityStatus()) || OMEntityWrapper.EntityStatus.UPDATED.equals((Object)tableTypeEntityWrapper.getEntityStatus());
    }

    private void deleteView(NewViewEvent event) throws UserNotAuthorizedException, EntityNotKnownException, EntityNotDeletedException, InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, TypeErrorException, PropertyErrorException, PagingErrorException {
        String qualifiedNameForTable;
        EntityDetail tableEntity;
        String qualifiedNameForInformationView = QualifiedNameUtils.buildQualifiedNameForInformationView(event.getTableSource().getDatabaseSource().getEndpointSource().getNetworkAddress().split(":")[0], event.getTableSource().getName(), event.getTableSource().getSchemaName());
        String qualifiedNameForTableType = QualifiedNameUtils.buildQualifiedName(qualifiedNameForInformationView, "RelationalTableType", event.getTableSource().getName() + "_type");
        EntityDetail tableTypeEntity = this.omEntityDao.getEntity("RelationalTableType", qualifiedNameForTableType, false);
        if (tableTypeEntity != null) {
            List<Relationship> derivedColumns = this.omEntityDao.getRelationships("AttributeForSchema", tableTypeEntity.getGUID());
            this.deleteColumns(derivedColumns);
            this.omEntityDao.purgeEntity((EntitySummary)tableTypeEntity);
        }
        if ((tableEntity = this.omEntityDao.getEntity("RelationalTable", qualifiedNameForTable = QualifiedNameUtils.buildQualifiedName(qualifiedNameForInformationView, "RelationalTable", event.getTableSource().getName()), false)) != null) {
            this.omEntityDao.purgeEntity((EntitySummary)tableEntity);
        }
    }

    private void deleteColumns(List<Relationship> columns) {
        if (columns != null && !columns.isEmpty()) {
            columns.parallelStream().forEach(c -> this.deleteEntity(c.getEntityTwoProxy()));
        }
    }

    private void deleteEntity(EntityProxy proxy) {
        try {
            this.omEntityDao.purgeEntity((EntitySummary)proxy);
        }
        catch (EntityNotDeletedException | EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            log.error(e.getMessage(), e);
        }
    }

    private EntityDetail addDerivedColumn(EntityDetail tableTypeEntity, String qualifiedNameForTable, DerivedColumn derivedColumn) {
        try {
            String qualifiedNameColumnType = QualifiedNameUtils.buildQualifiedName(qualifiedNameForTable, "RelationalColumnType", derivedColumn.getName() + "_type");
            InstanceProperties columnTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameColumnType).withStringProperty("displayName", derivedColumn.getName() + "_type").withStringProperty("author", "").withStringProperty("usage", "").withStringProperty("encodingStandard", "").withStringProperty("dataType", derivedColumn.getType()).build();
            EntityDetail columnTypeEntity = this.omEntityDao.addEntity("RelationalColumnType", qualifiedNameColumnType, columnTypeProperties, false);
            String qualifiedNameForColumn = QualifiedNameUtils.buildQualifiedName(qualifiedNameForTable, "DerivedRelationalColumn", derivedColumn.getName());
            InstanceProperties columnProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForColumn).withStringProperty("name", derivedColumn.getName()).withStringProperty("formula", "").withIntegerProperty("position", derivedColumn.getPosition()).build();
            EntityDetail derivedColumnEntity = this.omEntityDao.addEntity("DerivedRelationalColumn", qualifiedNameForColumn, columnProperties, false);
            derivedColumn.setGuid(derivedColumnEntity.getGUID());
            this.addRelationship(tableTypeEntity.getGUID(), derivedColumnEntity.getGUID(), "AttributeForSchema");
            this.addRelationship(derivedColumnEntity.getGUID(), derivedColumn.getSourceColumn().getGuid(), "SchemaQueryImplementation");
            this.addRelationship(derivedColumnEntity.getGUID(), columnTypeEntity.getGUID(), "SchemaAttributeType");
            for (BusinessTerm businessTerm : derivedColumn.getSourceColumn().getBusinessTerms()) {
                this.addRelationship(derivedColumnEntity.getGUID(), businessTerm.getGuid(), "SemanticAssignment");
            }
            return derivedColumnEntity;
        }
        catch (ClassificationErrorException | EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | StatusNotSupportedException | TypeErrorException | UserNotAuthorizedException e) {
            log.error("Exception", e);
            throw new RuntimeException("Exception creating derived column", e);
        }
    }

    private void addRelationship(String entityGuid1, String entityGuid2, String relationshipTypeName) {
        try {
            this.omEntityDao.addRelationship(relationshipTypeName, entityGuid1, entityGuid2, new InstanceProperties());
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | StatusNotSupportedException | TypeErrorException | UserNotAuthorizedException e) {
            log.error(e.getErrorMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

