/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.server;

import org.odpi.openmetadata.accessservices.dataplatform.handlers.RegistrationHandler;
import org.odpi.openmetadata.accessservices.dataplatform.properties.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataplatform.responses.RegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataplatform.server.DataPlatformInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPlatformRestServices {
    private static final Logger log = LoggerFactory.getLogger(DataPlatformRestServices.class);
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private DataPlatformInstanceHandler dataPlatformInstanceHandler = new DataPlatformInstanceHandler();

    public DataPlatformRestServices() {
    }

    public DataPlatformRestServices(DataPlatformInstanceHandler dataPlatformInstanceHandler) {
        this.dataPlatformInstanceHandler = dataPlatformInstanceHandler;
    }

    public GUIDResponse createSoftwareServer(String serverName, String userId, RegistrationRequestBody registrationRequestBody) {
        String methodName = "createSoftwareServer";
        log.debug("Calling method: {}", (Object)"createSoftwareServer");
        GUIDResponse response = new GUIDResponse();
        try {
            if (registrationRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSoftwareServer", serverName);
                return response;
            }
            RegistrationHandler handler = this.dataPlatformInstanceHandler.getRegistrationHandler(userId, serverName, "createSoftwareServer");
            SoftwareServerCapability softwareServerCapability = registrationRequestBody.getSoftwareServerCapability();
            response.setGUID(handler.createSoftwareServerCapability(softwareServerCapability));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {1} with response: {2}", (Object)"createSoftwareServer", (Object)response.toString());
        return response;
    }

    public RegistrationRequestBody getSoftwareServerCapabilityByQualifiedName(String serverName, String userId, String qualifiedName) {
        String methodName = "getSoftwareServerCapabilityByQualifiedName";
        RegistrationRequestBody response = new RegistrationRequestBody();
        try {
            RegistrationHandler handler = this.dataPlatformInstanceHandler.getRegistrationHandler(userId, serverName, "getSoftwareServerCapabilityByQualifiedName");
            response.setSoftwareServerCapability(handler.getSoftwareServerCapabilityByQualifiedName(userId, qualifiedName));
        }
        catch (InvalidParameterException error) {
            this.dataPlatformInstanceHandler.getExceptionHandler().captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.dataPlatformInstanceHandler.getExceptionHandler().capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.dataPlatformInstanceHandler.getExceptionHandler().captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {1} with response: {2}", (Object)"getSoftwareServerCapabilityByQualifiedName", (Object)response.toString());
        return response;
    }
}

