/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataplatform.auditlog.DataPlatformAuditCode;
import org.odpi.openmetadata.accessservices.dataplatform.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.dataplatform.listeners.DataPlatformInTopicListener;
import org.odpi.openmetadata.accessservices.dataplatform.server.DataPlatformServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPlatformAdmin
extends AccessServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(DataPlatformAdmin.class);
    private OpenMetadataTopicConnector dataPlatformInTopicConnector;
    private OMRSAuditLog auditLog = null;
    private String serverName = null;
    private DataPlatformServicesInstance instance = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "Initialize Data Platform OMAS server.";
        DataPlatformAuditCode auditCode = DataPlatformAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("Initialize Data Platform OMAS server.", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            this.auditLog = auditLog;
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DataPlatformServicesInstance(enterpriseConnector, supportedZones, auditLog);
            this.serverName = this.instance.getServerName();
            String inTopicName = this.getTopicName(accessServiceConfig.getAccessServiceInTopic());
            this.dataPlatformInTopicConnector = this.initializeDataPlatformTopicConnector(accessServiceConfig.getAccessServiceInTopic());
            OMEntityDao omEntityDao = new OMEntityDao(enterpriseConnector, supportedZones, auditLog);
            if (this.dataPlatformInTopicConnector != null) {
                DataPlatformInTopicListener dataPlatformInTopicListener = new DataPlatformInTopicListener(this.instance, omEntityDao, auditLog, enterpriseConnector.getRepositoryHelper());
                this.dataPlatformInTopicConnector.registerListener((OpenMetadataTopicListener)dataPlatformInTopicListener);
                this.startConnector(DataPlatformAuditCode.SERVICE_REGISTERED_WITH_DP_IN_TOPIC, "Initialize Data Platform OMAS server.", inTopicName, this.dataPlatformInTopicConnector);
            }
            auditCode = DataPlatformAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("Initialize Data Platform OMAS server.", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditCode = DataPlatformAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logRecord("Initialize Data Platform OMAS server.", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void startConnector(DataPlatformAuditCode auditCode, String actionDescription, String topicName, OpenMetadataTopicConnector topicConnector) throws OMAGConfigurationErrorException {
        this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(topicName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            topicConnector.start();
        }
        catch (ConnectorCheckedException e) {
            auditCode = DataPlatformAuditCode.ERROR_INITIALIZING_DATA_PLATFORM_TOPIC_CONNECTION;
            this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(topicName, this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMAGConfigurationErrorException(400, DataPlatformAdmin.class.getSimpleName(), actionDescription, auditCode.getFormattedLogMessage(new String[0]), auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private OpenMetadataTopicConnector initializeDataPlatformTopicConnector(Connection topicConnection) {
        String actionDescription = "initialize";
        if (topicConnection != null) {
            try {
                return this.getTopicConnector(topicConnection);
            }
            catch (Exception e) {
                DataPlatformAuditCode auditCode = DataPlatformAuditCode.ERROR_INITIALIZING_CONNECTION;
                this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(topicConnection.toString(), this.serverName, e.getMessage()), null, auditCode.getSystemAction(), auditCode.getUserAction());
                throw e;
            }
        }
        return null;
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog(this.auditLog.createNewAuditLog(OMRSAuditingComponent.OPEN_METADATA_TOPIC_CONNECTOR));
            return topicConnector;
        }
        catch (Throwable error) {
            String methodName = "getTopicConnector";
            if (log.isDebugEnabled()) {
                log.debug("Unable to create topic connector: " + error.toString());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getTopicConnector"});
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public void shutdown() {
        DataPlatformAuditCode auditCode;
        String actionDescription = "shutdown";
        try {
            this.dataPlatformInTopicConnector.disconnect();
        }
        catch (ConnectorCheckedException e) {
            auditCode = DataPlatformAuditCode.SERVICE_INSTANCE_TERMINATION_FAILURE;
            this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        auditCode = DataPlatformAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

