/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.listeners;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.odpi.openmetadata.accessservices.dataplatform.beans.InformationViewAsset;
import org.odpi.openmetadata.accessservices.dataplatform.beans.View;
import org.odpi.openmetadata.accessservices.dataplatform.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.dataplatform.events.DataPlatformEventHeader;
import org.odpi.openmetadata.accessservices.dataplatform.events.DataPlatformEventType;
import org.odpi.openmetadata.accessservices.dataplatform.events.NewDeployedDatabaseSchemaEvent;
import org.odpi.openmetadata.accessservices.dataplatform.events.NewViewEvent;
import org.odpi.openmetadata.accessservices.dataplatform.ffdc.DataPlatformErrorCode;
import org.odpi.openmetadata.accessservices.dataplatform.handlers.DeployedDatabaseSchemaAssetHandler;
import org.odpi.openmetadata.accessservices.dataplatform.handlers.InformationViewAssetHandler;
import org.odpi.openmetadata.accessservices.dataplatform.handlers.ViewHandler;
import org.odpi.openmetadata.accessservices.dataplatform.server.DataPlatformServicesInstance;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPlatformInTopicListener
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(DataPlatformInTopicListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final OMEntityDao omEntityDao;
    private final OMRSAuditLog auditLog;
    private OMRSRepositoryHelper repositoryHelper;
    private DataPlatformServicesInstance instance;

    public DataPlatformInTopicListener(DataPlatformServicesInstance instance, OMEntityDao omEntityDao, OMRSAuditLog auditLog, OMRSRepositoryHelper repositoryHelper) {
        this.instance = instance;
        this.omEntityDao = omEntityDao;
        this.auditLog = auditLog;
        this.repositoryHelper = repositoryHelper;
    }

    public void processEvent(String eventAsString) {
        try {
            DataPlatformEventHeader dataPlatformEventHeader = (DataPlatformEventHeader)OBJECT_MAPPER.readValue(eventAsString, DataPlatformEventHeader.class);
            if (dataPlatformEventHeader.getEventType() == DataPlatformEventType.NEW_DEPLOYED_DB_SCHEMA_EVENT) {
                NewDeployedDatabaseSchemaEvent newDeployedDatabaseSchemaEvent = (NewDeployedDatabaseSchemaEvent)OBJECT_MAPPER.readValue(eventAsString, NewDeployedDatabaseSchemaEvent.class);
                log.debug("Started processing NewDeployedDatabaseSchemaEvent event in DataPlatform OMAS");
                DeployedDatabaseSchemaAssetHandler handler = this.instance.getDeployedDatabaseSchemaAssetHandler();
                handler.createDeployedDatabaseSchemaAsset(newDeployedDatabaseSchemaEvent);
                log.debug("Processing NewDeployedDatabaseSchemaEvent event finished: {}", (Object)newDeployedDatabaseSchemaEvent);
            } else if (dataPlatformEventHeader.getEventType() == DataPlatformEventType.NEW_INFORMATION_VIEW_EVENT) {
                NewViewEvent newViewEvent = (NewViewEvent)OBJECT_MAPPER.readValue(eventAsString, NewViewEvent.class);
                log.debug("Started processing NewView event in DataPlatform OMAS");
                InformationViewAssetHandler informationViewAssetHandler = new InformationViewAssetHandler(newViewEvent, this.omEntityDao);
                ViewHandler viewsBuilder = new ViewHandler(newViewEvent, this.omEntityDao, this.repositoryHelper, this.auditLog);
                ExecutorService executor = Executors.newCachedThreadPool();
                Future<InformationViewAsset> informationViewAssetFuture = executor.submit(informationViewAssetHandler);
                Future<View> assetCreationFuture = executor.submit(viewsBuilder);
                InformationViewAsset informationViewAsset = informationViewAssetFuture.get();
                View view = assetCreationFuture.get();
                executor.shutdown();
                if (view.getViewEntity() != null) {
                    this.omEntityDao.addRelationship("AttributeForSchema", informationViewAsset.getRelationalDbSchemaType().getGUID(), view.getViewEntity().getGUID(), new InstanceProperties());
                    newViewEvent.getTableSource().setGuid(view.getViewEntity().getGUID());
                }
            }
        }
        catch (IOException e) {
            DataPlatformErrorCode errorCode = DataPlatformErrorCode.PARSE_EVENT_EXCEPTION;
            this.auditLog.logException("parseEvent", errorCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedErrorMessage(new String[]{eventAsString, e.getMessage()}), e.getMessage(), errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)e);
        }
        catch (Exception e) {
            log.debug("Exception processing event from in topic", (Throwable)e);
            DataPlatformErrorCode errorCode = DataPlatformErrorCode.PROCESS_EVENT_EXCEPTION;
            this.auditLog.logException("processEvent", errorCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedErrorMessage(new String[]{eventAsString, e.getMessage()}), e.getMessage(), errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)e);
        }
    }
}

