/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.server;

import org.odpi.openmetadata.accessservices.dataplatform.handlers.DeployedDatabaseSchemaAssetHandler;
import org.odpi.openmetadata.accessservices.dataplatform.handlers.RegistrationHandler;
import org.odpi.openmetadata.accessservices.dataplatform.properties.DeployedDatabaseSchema;
import org.odpi.openmetadata.accessservices.dataplatform.properties.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataplatform.responses.DataPlatformRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataplatform.responses.DeployedDatabaseSchemaRequestBody;
import org.odpi.openmetadata.accessservices.dataplatform.server.DataPlatformInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPlatformRestServices {
    private static final Logger log = LoggerFactory.getLogger(DataPlatformRestServices.class);
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private DataPlatformInstanceHandler dataPlatformInstanceHandler = new DataPlatformInstanceHandler();

    public DataPlatformRestServices() {
    }

    public DataPlatformRestServices(DataPlatformInstanceHandler dataPlatformInstanceHandler) {
        this.dataPlatformInstanceHandler = dataPlatformInstanceHandler;
    }

    public GUIDResponse createExternalDataPlatform(String serverName, String userId, DataPlatformRegistrationRequestBody dataPlatformRegistrationRequestBody) {
        String methodName = "createExternalDataPlatform";
        GUIDResponse response = new GUIDResponse();
        try {
            if (dataPlatformRegistrationRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalDataPlatform", serverName);
                return response;
            }
            RegistrationHandler handler = this.dataPlatformInstanceHandler.getRegistrationHandler(userId, serverName, "createExternalDataPlatform");
            SoftwareServerCapability softwareServerCapability = dataPlatformRegistrationRequestBody.getSoftwareServerCapability();
            response.setGUID(handler.createSoftwareServerCapability(softwareServerCapability));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {1} with response: {2}", (Object)"createExternalDataPlatform", (Object)response.toString());
        return response;
    }

    public DataPlatformRegistrationRequestBody getExternalDataPlatformByQualifiedName(String serverName, String userId, String qualifiedName) {
        String methodName = "getExternalDataPlatformByQualifiedName";
        DataPlatformRegistrationRequestBody response = new DataPlatformRegistrationRequestBody();
        try {
            RegistrationHandler handler = this.dataPlatformInstanceHandler.getRegistrationHandler(userId, serverName, "getExternalDataPlatformByQualifiedName");
            response.setSoftwareServerCapability(handler.getSoftwareServerCapabilityByQualifiedName(userId, qualifiedName));
        }
        catch (InvalidParameterException error) {
            this.dataPlatformInstanceHandler.getExceptionHandler().captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.dataPlatformInstanceHandler.getExceptionHandler().capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.dataPlatformInstanceHandler.getExceptionHandler().captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {1} with response: {2}", (Object)"getExternalDataPlatformByQualifiedName", (Object)response.toString());
        return response;
    }

    public GUIDResponse createDeployedDatabaseSchema(String serverName, String userId, DeployedDatabaseSchemaRequestBody deployedDatabaseSchemaRequestBody) {
        String methodName = "createDeployedDatabaseSchema";
        GUIDResponse response = new GUIDResponse();
        try {
            if (deployedDatabaseSchemaRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDeployedDatabaseSchema", serverName);
                return response;
            }
            DeployedDatabaseSchemaAssetHandler handler = this.dataPlatformInstanceHandler.getDeployedDatabaseSchemaAssetHandler(userId, serverName, "createDeployedDatabaseSchema");
            DeployedDatabaseSchema deployedDatabaseSchema = deployedDatabaseSchemaRequestBody.getDeployedDatabaseSchema();
            response.setGUID(handler.createDeployedDatabaseSchemaAsset(deployedDatabaseSchema));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {1} with response: {2}", (Object)"createDeployedDatabaseSchema", (Object)response.toString());
        return response;
    }
}

