/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataplatform.ffdc.DataPlatformErrorCode;
import org.odpi.openmetadata.accessservices.dataplatform.handlers.DeployedDatabaseSchemaAssetHandler;
import org.odpi.openmetadata.accessservices.dataplatform.handlers.RegistrationHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataPlatformServicesInstance
extends OCFOMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.DATA_PLATFORM_OMAS;
    private RegistrationHandler registrationHandler;
    private DeployedDatabaseSchemaAssetHandler deployedDatabaseSchemaAssetHandler;

    public DataPlatformServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, OMRSAuditLog auditLog) throws NewInstanceException {
        super(myDescription.getAccessServiceName() + " OMAS", repositoryConnector, supportedZones, null, auditLog);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler == null) {
            DataPlatformErrorCode errorCode = DataPlatformErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.registrationHandler = new RegistrationHandler(this.serverName, this.repositoryHelper, this.repositoryHandler, this.invalidParameterHandler);
        this.deployedDatabaseSchemaAssetHandler = new DeployedDatabaseSchemaAssetHandler(this.serviceName, this.serverName, this.repositoryHelper, this.repositoryHandler, this.invalidParameterHandler);
    }

    public static AccessServiceDescription getMyDescription() {
        return myDescription;
    }

    public RegistrationHandler getRegistrationHandler() {
        return this.registrationHandler;
    }

    public DeployedDatabaseSchemaAssetHandler getDeployedDatabaseSchemaAssetHandler() {
        return this.deployedDatabaseSchemaAssetHandler;
    }
}

