/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.contentmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.dataplatform.contentmanager.OMEntityWrapper;
import org.odpi.openmetadata.accessservices.dataplatform.ffdc.DataPlatformErrorCode;
import org.odpi.openmetadata.accessservices.dataplatform.utils.Constants;
import org.odpi.openmetadata.accessservices.dataplatform.utils.EntityPropertiesUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMEntityDao {
    private static final Logger log = LoggerFactory.getLogger(OMEntityDao.class);
    private final OMRSRepositoryConnector enterpriseConnector;
    private final OMRSAuditLog auditLog;
    private List<String> supportedZones;

    public OMEntityDao(OMRSRepositoryConnector enterpriseConnector, List<String> supportedZones, OMRSAuditLog auditLog) {
        this.enterpriseConnector = enterpriseConnector;
        this.auditLog = auditLog;
        this.supportedZones = supportedZones;
    }

    private EntityDetail addEntity(String metadataCollectionId, String userName, String typeName, InstanceProperties instanceProperties, List<Classification> classifications, boolean zoneRestricted) throws ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, FunctionNotSupportedException {
        try {
            EntityDetail entity = this.enterpriseConnector.getRepositoryHelper().getSkeletonEntity("DataPlatformOmas", metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userName, typeName);
            entity.setClassifications(classifications);
            if (zoneRestricted && this.supportedZones != null && !this.supportedZones.isEmpty()) {
                instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringArrayPropertyToInstance("DataPlatformOmas", instanceProperties, "zoneMembership", this.supportedZones, "addEntity");
            }
            return this.enterpriseConnector.getMetadataCollection().addEntity(userName, entity.getType().getTypeDefGUID(), instanceProperties, entity.getClassifications(), entity.getStatus());
        }
        catch (Exception e) {
            DataPlatformErrorCode errorCode = DataPlatformErrorCode.ADD_ENTITY_EXCEPTION;
            this.auditLog.logException("addEntity", errorCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedErrorMessage(new String[]{typeName, e.getMessage()}), "entity of type{" + typeName + "}", errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)e);
            throw e;
        }
    }

    private Relationship addRelationship(String metadataCollectionId, String typeName, InstanceProperties instanceProperties, String entityOneGUID, String entityTwoGUID) throws StatusNotSupportedException, UserNotAuthorizedException, EntityNotKnownException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, FunctionNotSupportedException {
        try {
            Relationship relationship = this.enterpriseConnector.getRepositoryHelper().getSkeletonRelationship("DataPlatformOmas", metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, "dataPlatformOmas", typeName);
            return this.enterpriseConnector.getMetadataCollection().addRelationship("dataPlatformOmas", relationship.getType().getTypeDefGUID(), instanceProperties, entityOneGUID, entityTwoGUID, InstanceStatus.ACTIVE);
        }
        catch (Exception e) {
            DataPlatformErrorCode errorCode = DataPlatformErrorCode.ADD_RELATIONSHIP_EXCEPTION;
            this.auditLog.logException("addRelationship", errorCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedErrorMessage(new String[]{typeName, e.getMessage()}), "relationship of type{" + typeName + "}", errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)e);
            throw e;
        }
    }

    public EntityDetail getEntity(String typeName, String qualifiedName, boolean zoneRestricted) throws PagingErrorException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("qualifiedName", qualifiedName);
        InstanceProperties matchProperties = this.buildMatchingInstanceProperties(properties, zoneRestricted);
        List<EntityDetail> existingEntities = this.findEntities(matchProperties, typeName, 0, Constants.PAGE_SIZE);
        return this.checkEntities(existingEntities, qualifiedName);
    }

    public List<EntityDetail> findEntities(InstanceProperties matchProperties, String typeName, int fromElement, int pageSize) throws PagingErrorException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException {
        List existingEntities;
        TypeDef typeDef = this.enterpriseConnector.getRepositoryHelper().getTypeDefByName("dataPlatformOmas", typeName);
        try {
            log.debug("Retrieving entities of type {} with properties {}", (Object)typeDef.getName(), (Object)matchProperties);
            existingEntities = this.enterpriseConnector.getMetadataCollection().findEntitiesByProperty("dataPlatformOmas", typeDef.getGUID(), matchProperties, MatchCriteria.ALL, fromElement, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, SequencingOrder.ANY, pageSize);
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            DataPlatformErrorCode errorCode = DataPlatformErrorCode.GET_ENTITY_EXCEPTION;
            this.auditLog.logException("retrieveEntity", errorCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedErrorMessage(new String[]{"matchProperties", "" + matchProperties, e.getMessage()}), "entity with properties {" + matchProperties + "}", errorCode.getSystemAction(), errorCode.getUserAction(), e);
            throw e;
        }
        return existingEntities;
    }

    public EntityDetail getEntityByGuid(String guid) throws RepositoryErrorException, UserNotAuthorizedException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException {
        return this.enterpriseConnector.getMetadataCollection().getEntityDetail("dataPlatformOmas", guid);
    }

    private EntityDetail checkEntities(List<EntityDetail> existingEntities, String qualifiedName) {
        if (existingEntities != null && !existingEntities.isEmpty()) {
            return existingEntities.stream().filter(e -> qualifiedName.equals(EntityPropertiesUtils.getStringValueForProperty(e.getProperties(), "qualifiedName"))).findFirst().orElse(null);
        }
        return null;
    }

    private Relationship getRelationship(String relationshipType, String guid1, String guid2) {
        List<Relationship> relationships;
        try {
            relationships = this.getRelationships(relationshipType, guid2);
        }
        catch (Exception e) {
            DataPlatformErrorCode errorCode = DataPlatformErrorCode.GET_RELATIONSHIP_EXCEPTION;
            this.auditLog.logException("getRelationship", errorCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedErrorMessage(new String[]{relationshipType, e.getMessage()}), "relationship with type" + relationshipType + " between {" + guid1 + ", " + guid2 + "}", errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)e);
            return null;
        }
        if (relationships != null && !relationships.isEmpty()) {
            for (Relationship relationship : relationships) {
                if (!relationship.getType().getTypeDefName().equals(relationshipType) || !this.checkRelationshipEnds(relationship, guid1, guid2)) continue;
                return relationship;
            }
        }
        return null;
    }

    public List<Relationship> getRelationships(String relationshipType, String guid2) {
        ArrayList<Relationship> relationships = new ArrayList();
        String relationshipTypeGuid = this.enterpriseConnector.getRepositoryHelper().getTypeDefByName("dataPlatformOmas", relationshipType).getGUID();
        try {
            log.debug("Retrieving relationships of type {} for entity {}", (Object)relationshipType, (Object)guid2);
            relationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("dataPlatformOmas", guid2, relationshipTypeGuid, 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, Constants.PAGE_SIZE.intValue());
        }
        catch (Exception e) {
            DataPlatformErrorCode errorCode = DataPlatformErrorCode.GET_RELATIONSHIP_EXCEPTION;
            this.auditLog.logException("getRelationships", errorCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedErrorMessage(new String[]{relationshipType, e.getMessage()}), "relationship with type" + relationshipType + " gor {" + guid2 + "}", errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)e);
        }
        return relationships;
    }

    private boolean checkRelationshipEnds(Relationship relationship, String guid1, String guid2) {
        String end1Guid = relationship.getEntityOneProxy().getGUID();
        String end2Guid = relationship.getEntityTwoProxy().getGUID();
        return end1Guid.equals(guid1) && end2Guid.equals(guid2) || end1Guid.equals(guid2) && end2Guid.equals(guid1);
    }

    public EntityDetail addEntity(String typeName, String qualifiedName, InstanceProperties properties, boolean zoneRestricted) throws InvalidParameterException, PropertyErrorException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, ClassificationErrorException, UserNotAuthorizedException, TypeErrorException, StatusNotSupportedException {
        return this.addEntity(typeName, qualifiedName, properties, null, zoneRestricted);
    }

    public EntityDetail addEntity(String typeName, String qualifiedName, InstanceProperties properties, List<Classification> classifications, boolean zoneRestricted) throws InvalidParameterException, StatusNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeErrorException, FunctionNotSupportedException, PagingErrorException, ClassificationErrorException, UserNotAuthorizedException, RepositoryErrorException {
        OMEntityWrapper wrapper = this.createOrUpdateEntity(typeName, qualifiedName, properties, classifications, false, zoneRestricted);
        return wrapper != null ? wrapper.getEntityDetail() : null;
    }

    public OMEntityWrapper createOrUpdateEntity(String typeName, String qualifiedName, InstanceProperties properties, List<Classification> classifications, boolean update, boolean zoneRestricted) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, ClassificationErrorException, StatusNotSupportedException, EntityNotKnownException {
        OMEntityWrapper wrapper;
        EntityDetail entityDetail = this.getEntity(typeName, qualifiedName, zoneRestricted);
        if (entityDetail == null) {
            entityDetail = this.addEntity("", "dataPlatformOmas", typeName, properties, classifications, zoneRestricted);
            log.debug("Entity with qualified name {} added", (Object)qualifiedName);
            wrapper = new OMEntityWrapper(entityDetail, OMEntityWrapper.EntityStatus.NEW);
        } else {
            log.debug("Entity with qualified name {} already exists", (Object)qualifiedName);
            if (update && !EntityPropertiesUtils.matchExactlyInstanceProperties(entityDetail.getProperties(), properties)) {
                log.debug("Updating entity with qualified name {} ", (Object)qualifiedName);
                entityDetail = this.updateEntity(entityDetail, "dataPlatformOmas", properties, zoneRestricted);
                wrapper = new OMEntityWrapper(entityDetail, OMEntityWrapper.EntityStatus.UPDATED);
            } else {
                wrapper = new OMEntityWrapper(entityDetail, OMEntityWrapper.EntityStatus.EXISTING);
            }
        }
        return wrapper;
    }

    private EntityDetail updateEntity(EntityDetail entityDetail, String userId, InstanceProperties instanceProperties, boolean zoneRestricted) throws RepositoryErrorException, UserNotAuthorizedException, InvalidParameterException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException {
        if (zoneRestricted) {
            instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringArrayPropertyToInstance("DataPlatformOmas", instanceProperties, "zoneMembership", this.supportedZones, "addEntity");
        }
        entityDetail = this.enterpriseConnector.getMetadataCollection().updateEntityProperties(userId, entityDetail.getGUID(), instanceProperties);
        return entityDetail;
    }

    public Relationship addRelationship(String relationshipType, String guid1, String guid2, InstanceProperties instanceProperties) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, UserNotAuthorizedException, RepositoryErrorException, StatusNotSupportedException {
        Relationship relationship = this.getRelationship(relationshipType, guid1, guid2);
        if (relationship == null) {
            relationship = this.addRelationship("", relationshipType, instanceProperties, guid1, guid2);
            log.debug("Relationship {} added between: {} and {}", new Object[]{relationshipType, guid1, guid2});
        } else {
            log.debug("Relationship {} already exists between: {} and {}", new Object[]{relationshipType, guid1, guid2});
        }
        return relationship;
    }

    public InstanceProperties buildMatchingInstanceProperties(Map<String, String> properties, boolean zoneRestricted) {
        InstanceProperties instanceProperties = new InstanceProperties();
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("DataPlatformOmas", instanceProperties, entry.getKey(), entry.getValue(), "buildMatchingInstanceProperties");
            }
        }
        if (zoneRestricted && this.supportedZones != null && !this.supportedZones.isEmpty()) {
            instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringArrayPropertyToInstance("DataPlatformOmas", instanceProperties, "zoneMembership", this.supportedZones, "buildMatchingInstanceProperties");
        }
        return instanceProperties;
    }

    public Classification buildClassification(String classificationTypeName, String entityTypeName, InstanceProperties classificationProperties) throws TypeErrorException {
        try {
            Classification classification = this.enterpriseConnector.getRepositoryHelper().getSkeletonClassification("DataPlatformOmas", "dataPlatformOmas", classificationTypeName, entityTypeName);
            classification.setProperties(classificationProperties);
            return classification;
        }
        catch (Exception e) {
            DataPlatformErrorCode errorCode = DataPlatformErrorCode.ADD_CLASSIFICATION_EXCEPTION;
            this.auditLog.logException("getClassification", errorCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedErrorMessage(new String[]{classificationTypeName, entityTypeName, e.getMessage()}), e.getMessage(), errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)e);
            throw e;
        }
    }

    public void purgeRelationship(Relationship relationship) throws RepositoryErrorException, UserNotAuthorizedException, InvalidParameterException, RelationshipNotDeletedException, RelationshipNotKnownException, FunctionNotSupportedException {
        if (relationship == null || relationship.getGUID() == null || relationship.getType() == null) {
            log.debug("Nothing will be purged, invalid relationship passed as argument: {}", (Object)relationship);
        } else {
            log.debug("Purge relationship with guid {}", (Object)relationship.getGUID());
            this.enterpriseConnector.getMetadataCollection().deleteRelationship("dataPlatformOmas", relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationship.getGUID());
            this.enterpriseConnector.getMetadataCollection().purgeRelationship("dataPlatformOmas", relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationship.getGUID());
        }
    }

    public void purgeEntity(EntitySummary entitySummary) throws RepositoryErrorException, UserNotAuthorizedException, InvalidParameterException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException {
        if (entitySummary == null || entitySummary.getGUID() == null || entitySummary.getType() == null) {
            log.debug("Nothing will be purged, invalid entity passed as argument: {}", (Object)entitySummary);
        } else {
            log.debug("Purge entity with guid {}", (Object)entitySummary.getGUID());
            this.enterpriseConnector.getMetadataCollection().deleteEntity("dataPlatformOmas", entitySummary.getType().getTypeDefGUID(), entitySummary.getType().getTypeDefName(), entitySummary.getGUID());
            this.enterpriseConnector.getMetadataCollection().purgeEntity("dataPlatformOmas", entitySummary.getType().getTypeDefGUID(), entitySummary.getType().getTypeDefName(), entitySummary.getGUID());
        }
    }
}

