/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.handlers;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.odpi.openmetadata.accessservices.dataplatform.beans.InformationViewAsset;
import org.odpi.openmetadata.accessservices.dataplatform.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.dataplatform.events.NewViewEvent;
import org.odpi.openmetadata.accessservices.dataplatform.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataplatform.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class InformationViewAssetHandler
implements Callable<InformationViewAsset> {
    private NewViewEvent event;
    private OMEntityDao omEntityDao;

    public InformationViewAssetHandler(NewViewEvent event, OMEntityDao omEntityDao) {
        this.event = event;
        this.omEntityDao = omEntityDao;
    }

    @Override
    public InformationViewAsset call() throws TypeErrorException, InvalidParameterException, StatusNotSupportedException, PropertyErrorException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, ClassificationErrorException, UserNotAuthorizedException, RepositoryErrorException {
        String qualifiedNameForRelationalDbSchemaType = QualifiedNameUtils.buildQualifiedNameForRelationalDbSchemaType(this.event.getTableSource().getDatabaseSource().getEndpointSource().getNetworkAddress().split(":")[0], this.event.getTableSource().getDatabaseSource().getName(), this.event.getTableSource().getSchemaName());
        EntityDetail relationalDbSchemaType = this.omEntityDao.getEntity("RelationalDBSchemaType", qualifiedNameForRelationalDbSchemaType, false);
        if (relationalDbSchemaType == null) {
            return this.createInformationView();
        }
        InformationViewAsset informationViewAsset = new InformationViewAsset();
        informationViewAsset.setRelationalDbSchemaType(relationalDbSchemaType);
        return informationViewAsset;
    }

    private InformationViewAsset createInformationView() throws TypeErrorException, InvalidParameterException, StatusNotSupportedException, PropertyErrorException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, ClassificationErrorException, UserNotAuthorizedException, RepositoryErrorException {
        InformationViewAsset informationViewAsset = new InformationViewAsset();
        String qualifiedNameForSoftwareServer = QualifiedNameUtils.buildQualifiedName("", "SoftwareServer", this.event.getTableSource().getDatabaseSource().getEndpointSource().getNetworkAddress().split(":")[0]);
        InstanceProperties softwareServerProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForSoftwareServer).withStringProperty("name", qualifiedNameForSoftwareServer).build();
        ArrayList<Classification> classificationList = new ArrayList<Classification>();
        classificationList.add(this.omEntityDao.buildClassification("DatabaseServer", "SoftwareServer", new InstanceProperties()));
        EntityDetail softwareServerEntity = this.omEntityDao.addEntity("SoftwareServer", qualifiedNameForSoftwareServer, softwareServerProperties, classificationList, true);
        informationViewAsset.setSoftwareServerEntity(softwareServerEntity);
        String qualifiedNameForEndpoint = QualifiedNameUtils.buildQualifiedName("", "Endpoint", this.event.getTableSource().getDatabaseSource().getEndpointSource().getProtocol() + this.event.getTableSource().getDatabaseSource().getEndpointSource().getNetworkAddress());
        InstanceProperties endpointProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForEndpoint).withStringProperty("name", qualifiedNameForEndpoint).withStringProperty("networkAddress", this.event.getTableSource().getDatabaseSource().getEndpointSource().getNetworkAddress()).withStringProperty("protocol", this.event.getTableSource().getDatabaseSource().getEndpointSource().getProtocol()).build();
        EntityDetail endpointEntity = this.omEntityDao.addEntity("Endpoint", qualifiedNameForEndpoint, endpointProperties, false);
        informationViewAsset.setEndpointProperties(endpointEntity);
        this.omEntityDao.addRelationship("ServerEndpoint", softwareServerEntity.getGUID(), endpointEntity.getGUID(), new InstanceProperties());
        String qualifiedNameForConnection = QualifiedNameUtils.buildQualifiedName(qualifiedNameForEndpoint, "Connection", this.event.getTableSource().getDatabaseSource().getEndpointSource().getUser());
        InstanceProperties connectionProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForConnection).withStringProperty("description", "Connection to " + qualifiedNameForConnection).build();
        EntityDetail connectionEntity = this.omEntityDao.addEntity("Connection", qualifiedNameForConnection, connectionProperties, false);
        informationViewAsset.setConnectionEntity(connectionEntity);
        this.omEntityDao.addRelationship("ConnectionEndpoint", endpointEntity.getGUID(), connectionEntity.getGUID(), new InstanceProperties());
        String qualifiedNameForConnectorType = QualifiedNameUtils.buildQualifiedName("", "ConnectionConnectorType", this.event.getTableSource().getDatabaseSource().getEndpointSource().getConnectorProviderName());
        InstanceProperties connectorTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForConnectorType).withStringProperty("connectorProviderClassName", this.event.getTableSource().getDatabaseSource().getEndpointSource().getConnectorProviderName()).build();
        EntityDetail connectorTypeEntity = this.omEntityDao.addEntity("ConnectorType", qualifiedNameForConnectorType, connectorTypeProperties, false);
        informationViewAsset.setConnectorTypeEntity(connectorTypeEntity);
        this.omEntityDao.addRelationship("ConnectionConnectorType", connectionEntity.getGUID(), connectorTypeEntity.getGUID(), new InstanceProperties());
        String qualifiedNameForDatabase = QualifiedNameUtils.buildQualifiedName(qualifiedNameForSoftwareServer, "Database", this.event.getTableSource().getDatabaseSource().getName());
        InstanceProperties databaseProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForDatabase).withStringProperty("name", this.event.getTableSource().getDatabaseSource().getName()).build();
        EntityDetail database = this.omEntityDao.addEntity("Database", qualifiedNameForDatabase, databaseProperties, true);
        informationViewAsset.setDatabase(database);
        this.omEntityDao.addRelationship("ConnectionToAsset", connectionEntity.getGUID(), database.getGUID(), new InstanceProperties());
        String qualifiedNameForInformationView = QualifiedNameUtils.buildQualifiedName(qualifiedNameForDatabase, "InformationView", this.event.getTableSource().getSchemaName());
        InstanceProperties ivProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForInformationView).withStringProperty("name", this.event.getTableSource().getSchemaName()).withStringProperty("owner", "").withStringProperty("description", "This asset is an information view").build();
        EntityDetail informationViewEntity = this.omEntityDao.addEntity("InformationView", qualifiedNameForInformationView, ivProperties, true);
        informationViewAsset.setInformationViewEntity(informationViewEntity);
        this.omEntityDao.addRelationship("DataContentForDataSet", database.getGUID(), informationViewEntity.getGUID(), new InstanceProperties());
        String qualifiedNameForDbSchemaType = QualifiedNameUtils.buildQualifiedName(qualifiedNameForDatabase, "RelationalDBSchemaType", this.event.getTableSource().getSchemaName() + "_type");
        InstanceProperties dbSchemaTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForDbSchemaType).withStringProperty("displayName", this.event.getTableSource().getSchemaName() + "_type").withStringProperty("author", "").withStringProperty("usage", "").withStringProperty("encodingStandard", "").build();
        EntityDetail relationalDbSchemaType = this.omEntityDao.addEntity("RelationalDBSchemaType", qualifiedNameForDbSchemaType, dbSchemaTypeProperties, false);
        informationViewAsset.setRelationalDbSchemaType(relationalDbSchemaType);
        this.omEntityDao.addRelationship("AssetSchemaType", informationViewEntity.getGUID(), relationalDbSchemaType.getGUID(), new InstanceProperties());
        return informationViewAsset;
    }
}

