/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.handlers;

import org.odpi.openmetadata.accessservices.dataplatform.properties.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataplatform.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RegistrationHandler {
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;

    public RegistrationHandler(String serviceName, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler) {
        this.serviceName = serviceName;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.invalidParameterHandler = invalidParameterHandler;
    }

    public String createSoftwareServerCapability(SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalDataPlatform";
        String qualifiedNameForSoftwareServer = softwareServerCapability.getQualifiedName();
        this.invalidParameterHandler.validateUserId("dataPlatformOmas", "createExternalDataPlatform");
        this.invalidParameterHandler.validateName(qualifiedNameForSoftwareServer, "qualifiedName", "createExternalDataPlatform");
        InstanceProperties softwareServerProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForSoftwareServer).withStringProperty("patchLevel", softwareServerCapability.getPatchLevel()).withStringProperty("type", softwareServerCapability.getDataPlatformType()).withStringProperty("version", softwareServerCapability.getDataPlatformVersion()).withStringProperty("source", softwareServerCapability.getSource()).withStringProperty("name", softwareServerCapability.getDisplayName()).withStringProperty("description", softwareServerCapability.getDescription()).build();
        return this.repositoryHandler.createEntity("dataPlatformOmas", this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "SoftwareServerCapability").getGUID(), "SoftwareServerCapability", softwareServerProperties, "createExternalDataPlatform");
    }

    public SoftwareServerCapability getSoftwareServerCapabilityByQualifiedName(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalDataPlatformByQualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getExternalDataPlatformByQualifiedName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getExternalDataPlatformByQualifiedName");
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, "getExternalDataPlatformByQualifiedName");
        EntityDetail entity = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", properties, this.repositoryHelper.getTypeDefByName("dataPlatformOmas", "SoftwareServerCapability").getGUID(), "SoftwareServerCapability", "getExternalDataPlatformByQualifiedName");
        return this.buildSoftwareServerCapabilitySource(entity);
    }

    private SoftwareServerCapability buildSoftwareServerCapabilitySource(EntityDetail entity) {
        String methodName = "buildSoftwareServerCapabilitySource";
        SoftwareServerCapability softwareServerCapability = new SoftwareServerCapability();
        softwareServerCapability.setDisplayName(this.repositoryHelper.getStringProperty("DataPlatformOmas", "name", entity.getProperties(), methodName));
        softwareServerCapability.setQualifiedName(this.repositoryHelper.getStringProperty("DataPlatformOmas", "qualifiedName", entity.getProperties(), methodName));
        softwareServerCapability.setDataPlatformVersion(this.repositoryHelper.getStringProperty("DataPlatformOmas", "version", entity.getProperties(), methodName));
        softwareServerCapability.setPatchLevel(this.repositoryHelper.getStringProperty("DataPlatformOmas", "patchLevel", entity.getProperties(), methodName));
        softwareServerCapability.setDataPlatformType(this.repositoryHelper.getStringProperty("DataPlatformOmas", "type", entity.getProperties(), methodName));
        softwareServerCapability.setDescription(this.repositoryHelper.getStringProperty("DataPlatformOmas", "description", entity.getProperties(), methodName));
        return softwareServerCapability;
    }
}

