/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataplatform.ffdc.DataPlatformAuditCode;
import org.odpi.openmetadata.accessservices.dataplatform.server.DataPlatformServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataPlatformAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private DataPlatformServicesInstance instance = null;
    private OpenMetadataTopicConnector inTopicConnector = null;
    private String serverName = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "Initialize Data Platform OMAS service.";
        auditLog.logMessage("Initialize Data Platform OMAS service.", DataPlatformAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = this.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List publishZones = this.extractPublishZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DataPlatformServicesInstance(repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), null);
            this.serverName = this.instance.getServerName();
            auditLog.logMessage("Initialize Data Platform OMAS service.", DataPlatformAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("Initialize Data Platform OMAS service.", DataPlatformAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("Initialize Data Platform OMAS service.", AccessServiceDescription.DATA_PLATFORM_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        try {
            if (this.inTopicConnector != null) {
                this.inTopicConnector.disconnect();
            }
        }
        catch (ConnectorCheckedException error) {
            this.auditLog.logException("shutdown", DataPlatformAuditCode.SERVICE_INSTANCE_TERMINATION_FAILURE.getMessageDefinition(new String[]{this.serverName}), (Throwable)error);
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", DataPlatformAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

