/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.dataplatformservices.admin;

import org.odpi.openmetadata.adapters.connectors.cassandra.CassandraStoreConnector;
import org.odpi.openmetadata.adapters.connectors.cassandra.CassandraStoreListener;
import org.odpi.openmetadata.adminservices.configuration.properties.DataPlatformConfig;
import org.odpi.openmetadata.dataplatformservices.auditlog.DataPlatformServicesAuditCode;
import org.odpi.openmetadata.dataplatformservices.listener.DataPlatformServicesCassandraListener;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopic;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPlatformOperationalServices {
    private static final Logger log = LoggerFactory.getLogger(DataPlatformOperationalServices.class);
    private String localServerName;
    private String localServerUserId;
    private String localServerType;
    private String localOrganizationName;
    private String localServerURL;
    private OMRSAuditLog auditLog;
    private OpenMetadataTopicConnector dataPlatformServiceOutTopicConnector;
    private CassandraStoreConnector cassandraStoreConnector;
    private DataPlatformServicesCassandraListener dataPlatformServicesCassandraListener;
    private DataPlatformConfig dataPlatformConfig;

    public DataPlatformOperationalServices(String localServerName, String localServerUserId, String localServerType, String localServerURL) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerType = localServerType;
        this.localServerURL = localServerURL;
    }

    public void initialize(DataPlatformConfig dataPlatformConfig, OMRSAuditLog auditLog) {
        String actionDescription = "initialize";
        if (dataPlatformConfig != null) {
            Connection dataPlatformConnection;
            this.auditLog = auditLog;
            this.dataPlatformConfig = dataPlatformConfig;
            DataPlatformServicesAuditCode auditCode = DataPlatformServicesAuditCode.SERVICE_INITIALIZING;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            log.info(auditCode.toString());
            if (dataPlatformConfig.getDataPlatformServerOutTopic() != null) {
                try {
                    this.dataPlatformServiceOutTopicConnector = this.getTopicConnector(dataPlatformConfig.getDataPlatformServerOutTopic(), auditLog);
                    this.dataPlatformServicesCassandraListener = new DataPlatformServicesCassandraListener(auditLog, (OpenMetadataTopic)this.dataPlatformServiceOutTopicConnector, dataPlatformConfig);
                    this.dataPlatformServiceOutTopicConnector.registerListener((OpenMetadataTopicListener)this.dataPlatformServicesCassandraListener);
                }
                catch (Exception e) {
                    auditCode = DataPlatformServicesAuditCode.ERROR_INITIALIZING_DP_IN_TOPIC_CONNECTION;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            if ((dataPlatformConnection = dataPlatformConfig.getDataPlatformConnection()) != null) {
                try {
                    ConnectorBroker connectorBroker = new ConnectorBroker();
                    this.cassandraStoreConnector = (CassandraStoreConnector)connectorBroker.getConnector(dataPlatformConnection);
                    log.info("Found connection: " + dataPlatformConnection);
                    this.cassandraStoreConnector.registerListener((CassandraStoreListener)this.dataPlatformServicesCassandraListener);
                }
                catch (Exception e) {
                    log.error("Error in initializing Cassandra connector: ", (Throwable)e);
                }
            }
            if (this.dataPlatformServiceOutTopicConnector != null) {
                try {
                    this.dataPlatformServiceOutTopicConnector.start();
                    auditCode = DataPlatformServicesAuditCode.OUTBOUND_TOPIC_CONNECTOR_INITIALIZED;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
                catch (Exception e) {
                    auditCode = DataPlatformServicesAuditCode.ERROR_INITIALIZING_DP_IN_TOPIC_CONNECTION;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            auditCode = DataPlatformServicesAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public boolean disconnect(boolean permanent) {
        try {
            this.cassandraStoreConnector.disconnect();
            this.dataPlatformServiceOutTopicConnector.disconnect();
            DataPlatformServicesAuditCode auditCode = DataPlatformServicesAuditCode.SERVICE_SHUTDOWN;
            this.auditLog.logRecord("Disconnecting", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return true;
        }
        catch (Exception e) {
            DataPlatformServicesAuditCode auditCode = DataPlatformServicesAuditCode.ERROR_SHUTDOWN;
            this.auditLog.logRecord("Disconnecting", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return false;
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, OMRSAuditLog auditLog) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog(auditLog);
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getTopicConnector"});
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
        }
    }

    public DataPlatformConfig getDataPlatformConfig() {
        return this.dataPlatformConfig;
    }
}

