/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.dataplatformservices.listener;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.UUID;
import org.odpi.openmetadata.accessservices.dataplatform.events.DataPlatformEventType;
import org.odpi.openmetadata.accessservices.dataplatform.events.NewDeployedDatabaseSchemaEvent;
import org.odpi.openmetadata.accessservices.dataplatform.properties.DataPlatform;
import org.odpi.openmetadata.accessservices.dataplatform.properties.cassandra.Column;
import org.odpi.openmetadata.accessservices.dataplatform.properties.cassandra.Keyspace;
import org.odpi.openmetadata.accessservices.dataplatform.properties.cassandra.Table;
import org.odpi.openmetadata.adapters.connectors.cassandra.CassandraStoreListener;
import org.odpi.openmetadata.adminservices.configuration.properties.DataPlatformConfig;
import org.odpi.openmetadata.dataplatformservices.auditlog.DataPlatformServicesAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopic;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPlatformServicesCassandraListener
implements CassandraStoreListener,
OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(DataPlatformServicesCassandraListener.class);
    private OMRSAuditLog auditLog;
    private OpenMetadataTopic dataPlatformServicesOutTopicConnector;
    private DataPlatformConfig dataPlatformConfig;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public DataPlatformServicesCassandraListener(OMRSAuditLog auditLog, OpenMetadataTopic dataPlatformServicesOutTopicConnector, DataPlatformConfig dataPlatformConfig) {
        this.auditLog = auditLog;
        this.dataPlatformServicesOutTopicConnector = dataPlatformServicesOutTopicConnector;
        this.dataPlatformConfig = dataPlatformConfig;
    }

    public void onKeyspaceAdded(KeyspaceMetadata keyspaceMetadata) {
        NewDeployedDatabaseSchemaEvent newDeployedDatabaseSchemaEvent = new NewDeployedDatabaseSchemaEvent();
        String actionDescription = "Sending NewDeployedDatabaseSchemaEvent to Data Platform OMAS in topic.";
        try {
            Keyspace keyspace = new Keyspace();
            DataPlatform dataPlatform = new DataPlatform();
            ArrayList<ConnectorType> connectorTypes = new ArrayList<ConnectorType>();
            connectorTypes.add(this.dataPlatformConfig.getDataPlatformConnection().getConnectorType());
            dataPlatform.setDataPlatformConnectorType(connectorTypes);
            dataPlatform.setDataPlatformEndpoint(this.dataPlatformConfig.getDataPlatformConnection().getEndpoint());
            if (!keyspaceMetadata.getTables().isEmpty()) {
                ArrayList<Table> tableList = new ArrayList<Table>();
                for (TableMetadata tableMetadata : keyspaceMetadata.getTables()) {
                    Table table = new Table();
                    table.setTableName(tableMetadata.getName());
                    table.setGuid(tableMetadata.getId().toString());
                    ArrayList<Column> columnList = new ArrayList<Column>();
                    for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
                        Column column = new Column();
                        column.setName(columnMetadata.getName());
                        column.setType(columnMetadata.getType().asFunctionParameterString());
                        columnList.add(column);
                    }
                    table.setColumns(columnList);
                    tableList.add(table);
                }
                keyspace.setTableList(tableList);
            }
            keyspace.setGuid(UUID.randomUUID().toString());
            keyspace.setKeyspaceName(keyspaceMetadata.getName());
            keyspace.setReplication(keyspaceMetadata.getReplication());
            keyspace.setReplicationStrategy((String)keyspaceMetadata.getReplication().get("class"));
            newDeployedDatabaseSchemaEvent.setKeyspace(keyspace);
            newDeployedDatabaseSchemaEvent.setDataPlatform(dataPlatform);
            newDeployedDatabaseSchemaEvent.setEventType(DataPlatformEventType.NEW_DEPLOYED_DB_SCHEMA_EVENT);
            log.info("Sending event to Data Platform OMAS in topic");
            log.debug("event: ", (Object)newDeployedDatabaseSchemaEvent);
            this.dataPlatformServicesOutTopicConnector.sendEvent(OBJECT_MAPPER.writeValueAsString((Object)newDeployedDatabaseSchemaEvent));
        }
        catch (JsonProcessingException | ConnectorCheckedException error) {
            log.error("Exception publishing event", error);
            DataPlatformServicesAuditCode errorCode = DataPlatformServicesAuditCode.PUBLISH_EVENT_EXCEPTION;
            this.auditLog.logException(actionDescription, errorCode.getLogMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedLogMessage(newDeployedDatabaseSchemaEvent.getClass().getName(), error.getMessage()), "newDeployedDatabaseSchemaEvent {" + newDeployedDatabaseSchemaEvent.toString() + "}", errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public void onKeyspaceRemoved(KeyspaceMetadata keyspaceMetadata) {
    }

    public void onKeyspaceChanged(KeyspaceMetadata keyspaceMetadata, KeyspaceMetadata keyspaceMetadata1) {
    }

    public void onTableAdded(TableMetadata tableMetadata) {
    }

    public void onTableRemoved(TableMetadata tableMetadata) {
    }

    public void onTableChanged(TableMetadata tableMetadata, TableMetadata tableMetadata1) {
    }

    public void onUserTypeAdded(UserType userType) {
    }

    public void onUserTypeRemoved(UserType userType) {
    }

    public void onUserTypeChanged(UserType userType, UserType userType1) {
    }

    public void onFunctionAdded(FunctionMetadata functionMetadata) {
    }

    public void onFunctionRemoved(FunctionMetadata functionMetadata) {
    }

    public void onFunctionChanged(FunctionMetadata functionMetadata, FunctionMetadata functionMetadata1) {
    }

    public void onAggregateAdded(AggregateMetadata aggregateMetadata) {
    }

    public void onAggregateRemoved(AggregateMetadata aggregateMetadata) {
    }

    public void onAggregateChanged(AggregateMetadata aggregateMetadata, AggregateMetadata aggregateMetadata1) {
    }

    public void onMaterializedViewAdded(MaterializedViewMetadata materializedViewMetadata) {
    }

    public void onMaterializedViewRemoved(MaterializedViewMetadata materializedViewMetadata) {
    }

    public void onMaterializedViewChanged(MaterializedViewMetadata materializedViewMetadata, MaterializedViewMetadata materializedViewMetadata1) {
    }

    public void onRegister(Cluster cluster) {
        String action = cluster.getMetadata().exportSchemaAsString();
        String action2 = cluster.getConfiguration().getPoolingOptions().toString();
        String action3 = cluster.getConfiguration().getProtocolOptions().getProtocolVersion().toString();
        log.info(action);
        log.info(action2);
        log.info(action3);
    }

    public void onUnregister(Cluster cluster) {
    }

    public void processEvent(String event) {
    }
}

