/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.dataplatformservices.admin;

import org.odpi.openmetadata.accessservices.dataplatform.client.DataPlatformClient;
import org.odpi.openmetadata.adminservices.configuration.properties.DataPlatformServicesConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.dataplatformservices.api.DataPlatformMetadataExtractorBase;
import org.odpi.openmetadata.dataplatformservices.auditlog.DataPlatformServicesAuditCode;
import org.odpi.openmetadata.dataplatformservices.ffdc.DataPlatformServicesErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPlatformOperationalServices {
    private static final Logger log = LoggerFactory.getLogger(DataPlatformOperationalServices.class);
    private String localServerName;
    private String localServerUserId;
    private String localServerPassword;
    private String localServerType;
    private String localOrganizationName;
    private String localServerURL;
    private OMRSAuditLog auditLog;
    private OpenMetadataTopicConnector dataPlatformOmasInTopicConnector;
    private DataPlatformMetadataExtractorBase dataPlatformConnector;
    private DataPlatformServicesConfig dataPlatformServicesConfig;

    public DataPlatformOperationalServices(String localServerName, String localServerUserId, String localServerType, String localServerURL) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerType = localServerType;
        this.localServerURL = localServerURL;
    }

    public void initialize(DataPlatformServicesConfig dataPlatformServicesConfig, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        if (dataPlatformServicesConfig != null) {
            DataPlatformClient dataPlatformClient;
            this.auditLog = auditLog;
            this.dataPlatformServicesConfig = dataPlatformServicesConfig;
            DataPlatformServicesAuditCode auditCode = DataPlatformServicesAuditCode.SERVICE_INITIALIZING;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            try {
                dataPlatformClient = new DataPlatformClient(dataPlatformServicesConfig.getDataPlatformServerName(), dataPlatformServicesConfig.getDataPlatformServerURL(), this.localServerUserId, this.localServerPassword);
                log.debug("Configuring the Data Platform OMAS Client: {}", (Object)dataPlatformClient);
            }
            catch (InvalidParameterException error) {
                throw new OMAGConfigurationErrorException(error.getReportedHTTPCode(), this.getClass().getName(), "initialize", error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), (Throwable)error);
            }
            Connection dataPlatformConnection = dataPlatformServicesConfig.getDataPlatformConnection();
            if (dataPlatformConnection != null) {
                log.info("Found Data Platform connection: " + dataPlatformServicesConfig.getDataPlatformConnection());
                try {
                    ConnectorBroker connectorBroker = new ConnectorBroker();
                    this.dataPlatformConnector = (DataPlatformMetadataExtractorBase)connectorBroker.getConnector(dataPlatformConnection);
                    this.dataPlatformConnector.setDataPlatformClient(dataPlatformClient);
                    log.debug("The following Data Platform Metadata Extractor has been configured: {}", (Object)this.dataPlatformConnector);
                }
                catch (Exception e) {
                    log.error("Exception in creating the Data Platform Connector: ", (Throwable)e);
                    auditCode = DataPlatformServicesAuditCode.ERROR_INITIALIZING_DATA_PLATFORM_CONNECTION;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            if (dataPlatformServicesConfig.getDataPlatformOmasInTopicName() != null) {
                try {
                    this.dataPlatformOmasInTopicConnector = this.getTopicConnector(dataPlatformServicesConfig.getDataPlatformOmasInTopic(), auditLog);
                    log.debug("Configuring Data Platform OMAS InTopic Connector: ", (Object)this.dataPlatformOmasInTopicConnector.toString());
                }
                catch (Exception e) {
                    auditCode = DataPlatformServicesAuditCode.ERROR_INITIALIZING_DP_OMAS_IN_TOPIC_CONNECTION;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            if (this.dataPlatformOmasInTopicConnector != null) {
                try {
                    this.dataPlatformOmasInTopicConnector.start();
                    auditCode = DataPlatformServicesAuditCode.DP_OMAS_IN_TOPIC_CONNECTION_INITIALIZED;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
                catch (Exception e) {
                    auditCode = DataPlatformServicesAuditCode.ERROR_INITIALIZING_DP_OMAS_IN_TOPIC_CONNECTION;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            auditCode = DataPlatformServicesAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public boolean disconnect(boolean permanent) {
        try {
            this.dataPlatformConnector.disconnect();
            this.dataPlatformOmasInTopicConnector.disconnect();
            DataPlatformServicesAuditCode auditCode = DataPlatformServicesAuditCode.SERVICE_SHUTDOWN;
            this.auditLog.logRecord("Disconnecting", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return true;
        }
        catch (Exception e) {
            DataPlatformServicesAuditCode auditCode = DataPlatformServicesAuditCode.ERROR_SHUTDOWN;
            this.auditLog.logRecord("Disconnecting", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return false;
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, OMRSAuditLog auditLog) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog((AuditLog)auditLog);
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            throw new OMRSConfigErrorException(DataPlatformServicesErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition("getTopicConnector"), this.getClass().getName(), "getTopicConnector", (Throwable)error);
        }
    }

    public DataPlatformServicesConfig getDataPlatformServicesConfig() {
        return this.dataPlatformServicesConfig;
    }
}

