/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataplatform.server.spring;

import org.odpi.openmetadata.accessservices.dataplatform.responses.RegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataplatform.server.DataPlatformRestServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/data-platform/users/{userId}"})
public class DataPlatformOMASResource {
    private DataPlatformRestServices restAPI = new DataPlatformRestServices();

    @PostMapping(path={"/software-server-capabilities"})
    public GUIDResponse createSoftwareServerCapability(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody RegistrationRequestBody requestBody) {
        return this.restAPI.createSoftwareServer(serverName, userId, requestBody);
    }

    @GetMapping(path={"/software-server-capabilities/{qualifiedName}"})
    public RegistrationRequestBody getSoftwareServerCapabilityByQualifiedName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getSoftwareServerCapabilityByQualifiedName(serverName, userId, qualifiedName);
    }
}

