/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataprivacy.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataprivacy.ffdc.DataPrivacyAuditCode;
import org.odpi.openmetadata.accessservices.dataprivacy.listener.DataPrivacyOMRSTopicListener;
import org.odpi.openmetadata.accessservices.dataprivacy.server.DataPrivacyServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataPrivacyAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private DataPrivacyServicesInstance instance = null;
    private String serverName = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", DataPrivacyAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DataPrivacyServicesInstance(repositoryConnector, supportedZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                DataPrivacyOMRSTopicListener omrsTopicListener = new DataPrivacyOMRSTopicListener(accessServiceConfig.getAccessServiceOutTopic(), repositoryConnector.getRepositoryHelper(), repositoryConnector.getRepositoryValidator(), accessServiceConfig.getAccessServiceName(), supportedZones, auditLog);
                super.registerWithEnterpriseTopic(accessServiceConfig.getAccessServiceName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
            }
            auditLog.logMessage("initialize", DataPrivacyAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}));
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", DataPrivacyAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.DATA_PRIVACY_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", DataPrivacyAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

