/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.database.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.integrationservices.database.api.DatabaseIntegratorAPI;

public class DatabaseIntegrator
implements DatabaseIntegratorAPI {
    private FFDCRESTClient restClient;
    private String serverName;
    private String serverPlatformRootURL;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public DatabaseIntegrator(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new FFDCRESTClient(serverName, serverPlatformRootURL, auditLog);
    }

    public DatabaseIntegrator(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new FFDCRESTClient(serverName, serverPlatformRootURL);
    }

    public DatabaseIntegrator(String serverName, String serverPlatformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new FFDCRESTClient(serverName, serverPlatformRootURL, userId, password, auditLog);
    }

    public DatabaseIntegrator(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new FFDCRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public ConnectorType validateConnector(String userId, String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateConnector";
        String nameParameter = "connectorProviderClassName";
        String urlTemplate = "/servers/{0}/open-metadata/integration-services/database-integrator/users/{1}/validate-connector";
        this.invalidParameterHandler.validateUserId(userId, "validateConnector");
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "validateConnector");
        ConnectorTypeResponse restResult = this.restClient.callOCFConnectorTypeGetRESTCall("validateConnector", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-services/database-integrator/users/{1}/validate-connector", new Object[]{this.serverName, userId, connectorProviderClassName});
        return restResult.getConnectorType();
    }
}

