/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.database.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DatabaseManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseManagerProperties;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.database.connector.DatabaseIntegratorConnector;
import org.odpi.openmetadata.integrationservices.database.connector.DatabaseIntegratorContext;
import org.odpi.openmetadata.integrationservices.database.ffdc.DatabaseIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.database.ffdc.DatabaseIntegratorErrorCode;

public class DatabaseIntegratorContextManager
extends IntegrationContextManager {
    private DatabaseManagerClient databaseManagerClient = null;
    private MetadataSourceClient metadataSourceClient = null;
    private DataManagerRESTClient restClient = null;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", DatabaseIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        this.restClient = this.localServerPassword == null ? new DataManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new DataManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.databaseManagerClient = new DatabaseManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize, this.auditLog);
        this.metadataSourceClient = new MetadataSourceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize, this.auditLog);
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataSourceQualifiedNameParameterName = "metadataSourceQualifiedName";
        String methodName = "setUpMetadataSource";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateName(metadataSourceQualifiedName, "metadataSourceQualifiedName", "setUpMetadataSource");
        String metadataSourceGUID = this.metadataSourceClient.getMetadataSourceGUID(this.localServerUserId, metadataSourceQualifiedName);
        if (metadataSourceGUID == null) {
            DatabaseManagerProperties properties = new DatabaseManagerProperties();
            properties.setQualifiedName(metadataSourceQualifiedName);
            metadataSourceGUID = this.metadataSourceClient.createDatabaseManager(this.localServerUserId, null, null, properties);
        }
        return metadataSourceGUID;
    }

    public void setContext(String connectorId, String connectorName, String metadataSourceQualifiedName, IntegrationConnector integrationConnector, PermittedSynchronization permittedSynchronization, Map<String, Object> serviceOptions) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (serviceOptions != null) {
            serviceOptionsString = serviceOptions.toString();
        }
        if (!(integrationConnector instanceof DatabaseIntegratorConnector)) {
            String parameterName = "integrationConnector";
            throw new InvalidParameterException(DatabaseIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.DATABASE_INTEGRATOR_OMIS.getIntegrationServiceFullName(), DatabaseIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
        }
        this.auditLog.logMessage("setContext", DatabaseIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
        DatabaseIntegratorConnector serviceSpecificConnector = (DatabaseIntegratorConnector)integrationConnector;
        String metadataSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
        DataManagerEventClient dataManagerEventClient = new DataManagerEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, (OCFRESTClient)this.restClient, this.maxPageSize, this.auditLog, connectorId);
        serviceSpecificConnector.setContext(new DatabaseIntegratorContext(this.databaseManagerClient, dataManagerEventClient, this.localServerUserId, metadataSourceGUID, metadataSourceQualifiedName));
    }
}

