/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.EventBrokerInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.SchemaManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EventTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.TopicElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.EventTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TopicProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventTypeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventTypesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TopicRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TopicResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.TopicsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class EventBrokerClient
extends SchemaManagerClient
implements EventBrokerInterface {
    private static final String topicURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics";
    private static final String defaultSchemaAttributeName = "EventSchemaAttribute";

    public EventBrokerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, auditLog);
    }

    public EventBrokerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot);
    }

    public EventBrokerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public EventBrokerClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public EventBrokerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password);
    }

    @Override
    public String createTopic(String userId, String eventBrokerGUID, String eventBrokerName, boolean eventBrokerIsHome, TopicProperties topicProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createTopic";
        String propertiesParameterName = "topicProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createTopic");
        this.invalidParameterHandler.validateObject(topicProperties, "topicProperties", "createTopic");
        this.invalidParameterHandler.validateName(topicProperties.getQualifiedName(), "qualifiedName", "createTopic");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics?eventBrokerIsHome={2}";
        TopicRequestBody requestBody = new TopicRequestBody(topicProperties);
        requestBody.setExternalSourceGUID(eventBrokerGUID);
        requestBody.setExternalSourceName(eventBrokerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createTopic", urlTemplate, requestBody, this.serverName, userId, eventBrokerIsHome);
        return restResult.getGUID();
    }

    @Override
    public String createTopicFromTemplate(String userId, String eventBrokerGUID, String eventBrokerName, boolean eventBrokerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createTopicFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createTopicFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createTopicFromTemplate");
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", "createTopicFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createTopicFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/from-template/{2}?eventBrokerIsHome={3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(eventBrokerGUID);
        requestBody.setExternalSourceName(eventBrokerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createTopicFromTemplate", urlTemplate, requestBody, this.serverName, userId, templateGUID, eventBrokerIsHome);
        return restResult.getGUID();
    }

    @Override
    public void updateTopic(String userId, String eventBrokerGUID, String eventBrokerName, String topicGUID, boolean isMergeUpdate, TopicProperties topicProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateTopic";
        String elementGUIDParameterName = "topicGUID";
        String propertiesParameterName = "topicProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateTopic");
        this.invalidParameterHandler.validateGUID(topicGUID, "topicGUID", "updateTopic");
        this.invalidParameterHandler.validateObject(topicProperties, "topicProperties", "updateTopic");
        this.invalidParameterHandler.validateName(topicProperties.getQualifiedName(), "qualifiedName", "updateTopic");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/{2}?isMergeUpdate={3}";
        TopicRequestBody requestBody = new TopicRequestBody(topicProperties);
        requestBody.setExternalSourceGUID(eventBrokerGUID);
        requestBody.setExternalSourceName(eventBrokerName);
        this.restClient.callVoidPostRESTCall("updateTopic", urlTemplate, requestBody, this.serverName, userId, topicGUID, isMergeUpdate);
    }

    @Override
    public void publishTopic(String userId, String topicGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishTopic";
        String elementGUIDParameterName = "topicGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishTopic");
        this.invalidParameterHandler.validateGUID(topicGUID, "topicGUID", "publishTopic");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/{2}/publish";
        this.restClient.callVoidPostRESTCall("publishTopic", urlTemplate, nullRequestBody, this.serverName, userId, topicGUID);
    }

    @Override
    public void withdrawTopic(String userId, String topicGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawTopic";
        String elementGUIDParameterName = "topicGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawTopic");
        this.invalidParameterHandler.validateGUID(topicGUID, "topicGUID", "withdrawTopic");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/{2}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawTopic", urlTemplate, nullRequestBody, this.serverName, userId, topicGUID);
    }

    @Override
    public void removeTopic(String userId, String eventBrokerGUID, String eventBrokerName, String topicGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeTopic";
        String elementGUIDParameterName = "topicGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeTopic");
        this.invalidParameterHandler.validateGUID(topicGUID, "topicGUID", "removeTopic");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeTopic");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(eventBrokerGUID);
        requestBody.setExternalSourceName(eventBrokerName);
        this.restClient.callVoidPostRESTCall("removeTopic", urlTemplate, requestBody, this.serverName, userId, topicGUID, qualifiedName);
    }

    @Override
    public List<TopicElement> findTopics(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findTopics";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findTopics");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findTopics");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findTopics");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        TopicsResponse restResult = this.restClient.callTopicsPostRESTCall("findTopics", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<TopicElement> getTopicsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTopicsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getTopicsByName");
        this.invalidParameterHandler.validateName(name, "name", "getTopicsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTopicsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        TopicsResponse restResult = this.restClient.callTopicsPostRESTCall("getTopicsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<TopicElement> getTopicsForEventBroker(String userId, String eventBrokerGUID, String eventBrokerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTopicsForEventBroker";
        String eventBrokerGUIDParameterName = "eventBrokerGUID";
        String eventBrokerNameParameterName = "eventBrokerName";
        this.invalidParameterHandler.validateUserId(userId, "getTopicsForEventBroker");
        this.invalidParameterHandler.validateGUID(eventBrokerGUID, "eventBrokerGUID", "getTopicsForEventBroker");
        this.invalidParameterHandler.validateName(eventBrokerName, "eventBrokerName", "getTopicsForEventBroker");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTopicsForEventBroker");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/event-brokers/{2}/{3}/topics?startFrom={4}&pageSize={5}";
        TopicsResponse restResult = this.restClient.callTopicsGetRESTCall("getTopicsForEventBroker", urlTemplate, this.serverName, userId, eventBrokerGUID, eventBrokerName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public TopicElement getTopicByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTopicByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getTopicByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getTopicByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/{2}";
        TopicResponse restResult = this.restClient.callTopicGetRESTCall("getTopicByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    @Override
    public String createEventType(String userId, String eventBrokerGUID, String eventBrokerName, String topicGUID, EventTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEventType";
        String parentElementGUIDParameterName = "topicGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createEventType");
        this.invalidParameterHandler.validateGUID(topicGUID, "topicGUID", "createEventType");
        this.invalidParameterHandler.validateObject(properties, "properties", "createEventType");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createEventType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/{2}/event-types";
        EventTypeRequestBody requestBody = new EventTypeRequestBody(properties);
        requestBody.setExternalSourceGUID(eventBrokerGUID);
        requestBody.setExternalSourceName(eventBrokerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEventType", urlTemplate, requestBody, this.serverName, userId, topicGUID);
        return restResult.getGUID();
    }

    @Override
    public String createEventTypeFromTemplate(String userId, String eventBrokerGUID, String eventBrokerName, String templateGUID, String topicGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEventTypeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "topicGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createEventTypeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createEventTypeFromTemplate");
        this.invalidParameterHandler.validateGUID(topicGUID, "topicGUID", "createEventTypeFromTemplate");
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", "createEventTypeFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/{2}/event-types/from-template/{3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(eventBrokerGUID);
        requestBody.setExternalSourceName(eventBrokerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEventTypeFromTemplate", urlTemplate, requestBody, this.serverName, userId, topicGUID, templateGUID);
        return restResult.getGUID();
    }

    @Override
    public void updateEventType(String userId, String eventBrokerGUID, String eventBrokerName, String eventTypeGUID, boolean isMergeUpdate, EventTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEventType";
        String elementGUIDParameterName = "eventTypeGUID";
        String propertiesParameterName = "topicProperties";
        this.invalidParameterHandler.validateUserId(userId, "updateEventType");
        this.invalidParameterHandler.validateGUID(eventTypeGUID, "eventTypeGUID", "updateEventType");
        this.invalidParameterHandler.validateObject(properties, "topicProperties", "updateEventType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/event-types/{2}?isMergeUpdate={3}";
        EventTypeRequestBody requestBody = new EventTypeRequestBody(properties);
        requestBody.setExternalSourceGUID(eventBrokerGUID);
        requestBody.setExternalSourceName(eventBrokerName);
        this.restClient.callVoidPostRESTCall("updateEventType", urlTemplate, requestBody, this.serverName, userId, eventTypeGUID, isMergeUpdate);
    }

    @Override
    public void removeEventType(String userId, String eventBrokerGUID, String eventBrokerName, String eventTypeGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeEventType";
        String elementGUIDParameterName = "eventTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeEventType");
        this.invalidParameterHandler.validateGUID(eventTypeGUID, "eventTypeGUID", "removeEventType");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeEventType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/event-types/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(eventBrokerGUID);
        requestBody.setExternalSourceName(eventBrokerName);
        this.restClient.callVoidPostRESTCall("removeEventType", urlTemplate, requestBody, this.serverName, userId, eventTypeGUID, qualifiedName);
    }

    @Override
    public List<EventTypeElement> findEventTypes(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findEventTypes";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findEventTypes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findEventTypes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findEventTypes");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/event-types/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        EventTypesResponse restResult = this.restClient.callEventTypesPostRESTCall("findEventTypes", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<EventTypeElement> getEventTypesForEventSet(String userId, String eventSetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEventTypesForTopic";
        String parentElementGUIDParameterName = "topicGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEventTypesForTopic");
        this.invalidParameterHandler.validateGUID(eventSetGUID, "topicGUID", "getEventTypesForTopic");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEventTypesForTopic");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/event-sets/{2}/event-types?startFrom={3}&pageSize={4}";
        EventTypesResponse restResult = this.restClient.callEventTypesGetRESTCall("getEventTypesForTopic", urlTemplate, this.serverName, userId, eventSetGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<EventTypeElement> getEventTypesForTopic(String userId, String topicGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEventTypesForTopic";
        String parentElementGUIDParameterName = "topicGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEventTypesForTopic");
        this.invalidParameterHandler.validateGUID(topicGUID, "topicGUID", "getEventTypesForTopic");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEventTypesForTopic");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/{2}/event-types?startFrom={3}&pageSize={4}";
        EventTypesResponse restResult = this.restClient.callEventTypesGetRESTCall("getEventTypesForTopic", urlTemplate, this.serverName, userId, topicGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<EventTypeElement> getEventTypesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEventTypesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getEventTypesByName");
        this.invalidParameterHandler.validateName(name, "name", "getEventTypesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEventTypesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/event-types/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        EventTypesResponse restResult = this.restClient.callEventTypesPostRESTCall("getEventTypesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public EventTypeElement getEventTypeByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEventTypeByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getEventTypeByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getEventTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/topics/event-types/{2}";
        EventTypeResponse restResult = this.restClient.callEventTypeGetRESTCall("getEventTypeByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }
}

