/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerEventHeader;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEventType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataManagerOutboundEvent
extends DataManagerEventHeader {
    private static final long serialVersionUID = 1L;
    private DataManagerOutboundEventType eventType = null;
    private ElementStub principleElement = null;
    private String classificationName = null;
    private ElementStub endOneElement = null;
    private ElementStub endTwoElement = null;

    public DataManagerOutboundEvent() {
    }

    public DataManagerOutboundEvent(DataManagerOutboundEvent template) {
        super(template);
        if (template != null) {
            this.eventType = template.getEventType();
            this.principleElement = template.getPrincipleElement();
            this.classificationName = template.getClassificationName();
            this.endOneElement = template.getEndOneElement();
            this.endTwoElement = template.getEndTwoElement();
        }
    }

    public DataManagerOutboundEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(DataManagerOutboundEventType eventType) {
        this.eventType = eventType;
    }

    public ElementStub getPrincipleElement() {
        return this.principleElement;
    }

    public void setPrincipleElement(ElementStub principleElement) {
        this.principleElement = principleElement;
    }

    public String getClassificationName() {
        return this.classificationName;
    }

    public void setClassificationName(String classificationName) {
        this.classificationName = classificationName;
    }

    public ElementStub getEndOneElement() {
        return this.endOneElement;
    }

    public void setEndOneElement(ElementStub endOneElement) {
        this.endOneElement = endOneElement;
    }

    public ElementStub getEndTwoElement() {
        return this.endTwoElement;
    }

    public void setEndTwoElement(ElementStub endTwoElement) {
        this.endTwoElement = endTwoElement;
    }

    @Override
    public String toString() {
        return "DataManagerOutboundEvent{eventType=" + this.eventType + ", principleElement=" + this.principleElement + ", classificationName='" + this.classificationName + "', endOneElement=" + this.endOneElement + ", endTwoElement=" + this.endTwoElement + ", eventVersionId=" + this.getEventVersionId() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataManagerOutboundEvent that = (DataManagerOutboundEvent)objectToCompare;
        return this.eventType == that.eventType && Objects.equals(this.principleElement, that.principleElement) && Objects.equals(this.classificationName, that.classificationName) && Objects.equals(this.endOneElement, that.endOneElement) && Objects.equals(this.endTwoElement, that.endTwoElement);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.eventType, this.principleElement, this.classificationName, this.endOneElement, this.endTwoElement);
    }
}

