/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DatabaseTableElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private ElementHeader elementHeader = null;
    private DatabaseTableProperties databaseTableProperties = null;
    private int databaseColumnCount = 0;

    public DatabaseTableElement() {
    }

    public DatabaseTableElement(DatabaseTableElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.databaseTableProperties = template.getDatabaseTableProperties();
            this.databaseColumnCount = template.getDatabaseColumnCount();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public DatabaseTableProperties getDatabaseTableProperties() {
        return this.databaseTableProperties;
    }

    public void setDatabaseTableProperties(DatabaseTableProperties databaseTableProperties) {
        this.databaseTableProperties = databaseTableProperties;
    }

    public int getDatabaseColumnCount() {
        return this.databaseColumnCount;
    }

    public void setDatabaseColumnCount(int databaseColumnCount) {
        this.databaseColumnCount = databaseColumnCount;
    }

    public String toString() {
        return "DatabaseTableElement{elementHeader=" + this.elementHeader + ", databaseTableProperties=" + this.databaseTableProperties + ", databaseColumnCount=" + this.databaseColumnCount + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        DatabaseTableElement that = (DatabaseTableElement)objectToCompare;
        return this.databaseColumnCount == that.databaseColumnCount && Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.databaseTableProperties, that.databaseTableProperties);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.databaseTableProperties, this.databaseColumnCount);
    }
}

