/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataSetProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataStoreProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataSetProperties.class, name="DataSetProperties"), @JsonSubTypes.Type(value=DataStoreProperties.class, name="DataStoreProperties"), @JsonSubTypes.Type(value=APIProperties.class, name="APIProperties")})
public class AssetProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String versionIdentifier = null;
    private String description = null;

    public AssetProperties() {
    }

    public AssetProperties(AssetProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.versionIdentifier = template.getVersionIdentifier();
            this.description = template.getDescription();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    @Deprecated
    public String getDisplayName() {
        return this.name;
    }

    @Deprecated
    public void setDisplayName(String displayName) {
        this.name = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "AssetProperties{name='" + this.name + "', versionIdentifier='" + this.versionIdentifier + "', name='" + this.name + "', description='" + this.description + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetProperties that = (AssetProperties)objectToCompare;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.versionIdentifier != null ? !this.versionIdentifier.equals(that.versionIdentifier) : that.versionIdentifier != null) {
            return false;
        }
        return this.description != null ? this.description.equals(that.description) : that.description == null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.versionIdentifier, this.description);
    }
}

