/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.restclients.spring;

import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.Base64;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.RESTClientConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.exceptions.RESTServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.http.HttpHeadersThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;

public class SpringRESTClientConnector
extends RESTClientConnector {
    private final RestTemplate restTemplate;
    private String serverName = null;
    private String serverPlatformURLRoot = null;
    private HttpHeaders basicAuthorizationHeader = null;
    private static final Logger log = LoggerFactory.getLogger(SpringRESTClientConnector.class);

    public SpringRESTClientConnector() throws NoSuchAlgorithmException, KeyManagementException {
        DefaultUriBuilderFactory builderFactory = new DefaultUriBuilderFactory();
        builderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.VALUES_ONLY);
        this.restTemplate = new RestTemplate();
        this.restTemplate.setUriTemplateHandler(builderFactory);
        List<HttpMessageConverter<?>> converters = this.restTemplate.getMessageConverters();
        converters.removeIf(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter);
        converters.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    @Override
    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.serverPlatformURLRoot = endpoint.getAddress();
            this.serverName = endpoint.getDisplayName();
        } else {
            log.error("No endpoint for connector.");
            this.serverPlatformURLRoot = null;
            this.serverName = null;
        }
        String userId = connectionProperties.getUserId();
        String password = connectionProperties.getClearPassword();
        if (userId != null && password != null) {
            log.debug("Using basic authentication to call server {}  on platform {} .", (Object)this.serverName, (Object)this.serverPlatformURLRoot);
            this.basicAuthorizationHeader = this.createHeaders(userId, password);
        } else {
            log.debug("Using no authentication to call server {} on platform {} .", (Object)this.serverName, (Object)this.serverPlatformURLRoot);
        }
    }

    private HttpHeaders createHeaders(String username, String password) {
        String authorizationString = username + ":" + password;
        byte[] encodedAuthorizationString = Base64.encodeBase64(authorizationString.getBytes(StandardCharsets.US_ASCII));
        String authHeader = "Basic " + new String(encodedAuthorizationString);
        HttpHeaders header = new HttpHeaders();
        header.set("Authorization", authHeader);
        return header;
    }

    @Override
    public <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws RESTServerException {
        try {
            T responseObject;
            log.debug("Calling {} with URL template {} and no parameters.", (Object)methodName, (Object)urlTemplate);
            HttpHeaders headers = this.getHttpHeaders();
            if (headers.isEmpty()) {
                responseObject = this.restTemplate.getForObject(urlTemplate, returnClass, new Object[0]);
            } else {
                HttpEntity request = new HttpEntity(headers);
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    @Override
    public <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws RESTServerException {
        try {
            T responseObject;
            HttpHeaders headers;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((headers = this.getHttpHeaders()).isEmpty()) {
                responseObject = this.restTemplate.getForObject(urlTemplate, returnClass, params);
            } else {
                HttpEntity request = new HttpEntity(headers);
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request, returnClass, params);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    @Override
    public <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            T responseObject;
            log.debug("Calling {} with URL template {} and no parameters.", (Object)methodName, (Object)urlTemplate);
            HttpHeaders headers = this.getHttpHeaders();
            if (headers.isEmpty()) {
                responseObject = this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, new Object[0]);
            } else {
                HttpEntity<Object> request;
                if (requestBody != null) {
                    request = new HttpEntity<Object>(requestBody, headers);
                } else {
                    log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                    request = new HttpEntity(headers);
                }
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    @Override
    public <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            T responseObject;
            HttpHeaders headers;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((headers = this.getHttpHeaders()).isEmpty()) {
                responseObject = this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, params);
            } else {
                HttpEntity<Object> request;
                if (requestBody != null) {
                    request = new HttpEntity<Object>(requestBody, headers);
                } else {
                    log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                    request = new HttpEntity(headers);
                }
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, returnClass, params);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    @Override
    public <T> T callPutRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            HttpEntity<Object> request = new HttpEntity<Object>(requestBody);
            if (requestBody == null) {
                log.warn("Poorly formed PUT call made by {}.", (Object)methodName);
            }
            if (this.basicAuthorizationHeader != null) {
                request = new HttpEntity<Object>(requestBody, this.basicAuthorizationHeader);
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.PUT, request, returnClass, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    @Override
    public <T> T callDeleteRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            log.debug("Calling {} with URL template {} and no parameters.", (Object)methodName, (Object)urlTemplate);
            T responseObject = null;
            HttpHeaders headers = this.getHttpHeaders();
            if (headers.isEmpty()) {
                this.restTemplate.delete(urlTemplate, new Object[0]);
            } else {
                HttpEntity<Object> request;
                if (requestBody != null) {
                    request = new HttpEntity<Object>(requestBody, headers);
                } else {
                    log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                    request = new HttpEntity(headers);
                }
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    @Override
    public <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            HttpEntity<Object> request = new HttpEntity<Object>(requestBody);
            if (this.basicAuthorizationHeader != null) {
                request = new HttpEntity<Object>(requestBody, this.basicAuthorizationHeader);
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request, returnClass, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.error("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public <T> T callPostRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            HttpEntity<Object> request;
            HttpHeaders headers;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((headers = this.getHttpHeaders()).isEmpty()) {
                request = new HttpEntity<Object>(requestBody);
            } else if (requestBody != null) {
                request = new HttpEntity<Object>(requestBody, headers);
            } else {
                log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                request = new HttpEntity(headers);
            }
            ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, responseType, params);
            Object responseObject = responseEntity.getBody();
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public <T> T callGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws RESTServerException {
        try {
            HttpHeaders headers;
            HttpEntity<Object> request;
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request = (headers = this.getHttpHeaders()).isEmpty() ? HttpEntity.EMPTY : new HttpEntity(headers), responseType, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public <T> T callDeleteRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            HttpEntity<Object> request = new HttpEntity<Object>(requestBody);
            if (this.basicAuthorizationHeader != null) {
                request = new HttpEntity<Object>(requestBody, this.basicAuthorizationHeader);
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request, responseType, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.error("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public <T> T callPutRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            HttpEntity<Object> request = new HttpEntity<Object>(requestBody);
            if (requestBody == null) {
                log.warn("Poorly formed PUT call made by {}", (Object)methodName);
            }
            if (this.basicAuthorizationHeader != null) {
                request = new HttpEntity<Object>(requestBody, this.basicAuthorizationHeader);
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.PUT, request, responseType, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            throw new RESTServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        Map<String, String> threadLocalHeaders = HttpHeadersThreadLocal.getHeadersThreadLocal().get();
        if (threadLocalHeaders != null) {
            for (Map.Entry<String, String> entry : threadLocalHeaders.entrySet()) {
                headers.set(entry.getKey(), entry.getValue());
            }
        }
        if (this.basicAuthorizationHeader != null) {
            headers.addAll(this.basicAuthorizationHeader);
        }
        return headers;
    }
}

