/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationConnectorConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class IntegrationServiceRequestBody
extends OMAGServerClientConfig {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> integrationServiceOptions = null;
    private List<IntegrationConnectorConfig> integrationConnectorConfigs = null;

    public IntegrationServiceRequestBody() {
    }

    public IntegrationServiceRequestBody(IntegrationServiceRequestBody template) {
        super(template);
        if (template != null) {
            this.integrationConnectorConfigs = template.getIntegrationConnectorConfigs();
            this.integrationServiceOptions = template.getIntegrationServiceOptions();
        }
    }

    public List<IntegrationConnectorConfig> getIntegrationConnectorConfigs() {
        return this.integrationConnectorConfigs;
    }

    public void setIntegrationConnectorConfigs(List<IntegrationConnectorConfig> integrationConnectorConfigs) {
        this.integrationConnectorConfigs = integrationConnectorConfigs;
    }

    public Map<String, Object> getIntegrationServiceOptions() {
        if (this.integrationServiceOptions == null) {
            return null;
        }
        if (this.integrationServiceOptions.isEmpty()) {
            return null;
        }
        return this.integrationServiceOptions;
    }

    public void setIntegrationServiceOptions(Map<String, Object> integrationServiceOptions) {
        this.integrationServiceOptions = integrationServiceOptions;
    }

    @Override
    public String toString() {
        return "IntegrationServiceRequestBody{integrationServiceOptions=" + this.integrationServiceOptions + ", integrationConnectorConfigs=" + this.integrationConnectorConfigs + ", OMAGServerPlatformRootURL='" + this.getOMAGServerPlatformRootURL() + "', OMAGServerName='" + this.getOMAGServerName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        IntegrationServiceRequestBody that = (IntegrationServiceRequestBody)objectToCompare;
        return Objects.equals(this.integrationServiceOptions, that.integrationServiceOptions) && Objects.equals(this.integrationConnectorConfigs, that.integrationConnectorConfigs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.integrationServiceOptions, this.integrationConnectorConfigs);
    }
}

