/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.OMAGCommonAuditCode;
import org.odpi.openmetadata.commonservices.ffdc.OMAGCommonErrorCode;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTExceptionHandler {
    private static final MessageFormatter messageFormatter = new MessageFormatter();
    private static final Logger log = LoggerFactory.getLogger(RESTExceptionHandler.class);

    public void handleNoRequestBody(String userId, String methodName, String serverName) throws InvalidParameterException {
        InvalidParameterException error = new InvalidParameterException(OMAGCommonErrorCode.NO_REQUEST_BODY.getMessageDefinition(userId, methodName, serverName), this.getClass().getName(), methodName, "requestBody");
        log.error("No rest body supplied", error);
        throw error;
    }

    public void handleNoRequestBody(String userId, String methodName, String serverName, String className) throws InvalidParameterException {
        InvalidParameterException error = new InvalidParameterException(OMAGCommonErrorCode.NO_REQUEST_BODY_FOR_CLASS.getMessageDefinition(userId, methodName, serverName, className), this.getClass().getName(), methodName, "requestBody");
        log.error("No rest body supplied", error);
        throw error;
    }

    public void handleMissingValue(String parameterName, String methodName) throws InvalidParameterException {
        InvalidParameterException error = new InvalidParameterException(OMAGCommonErrorCode.NULL_OBJECT.getMessageDefinition(parameterName, methodName), this.getClass().getName(), methodName, parameterName);
        log.error("Missing parameter", error);
        throw error;
    }

    public void handleInvalidPropertiesObject(String expectedClassName, String methodName) throws InvalidParameterException {
        InvalidParameterException error = new InvalidParameterException(OMAGCommonErrorCode.INVALID_PROPERTIES_OBJECT.getMessageDefinition(methodName, expectedClassName), this.getClass().getName(), methodName, expectedClassName);
        log.error("Wrong properties class", error);
        throw error;
    }

    public void handleBadType(String subTypeName, String superTypeName, String serviceName, String methodName) throws InvalidParameterException {
        InvalidParameterException error = new InvalidParameterException(OMAGCommonErrorCode.BAD_SUB_TYPE_NAME.getMessageDefinition(subTypeName, methodName, serviceName, superTypeName), this.getClass().getName(), methodName, subTypeName);
        log.error("Missing parameter", error);
        throw error;
    }

    public void detectAndThrowStandardExceptions(String methodName, FFDCResponse restResult) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String invalidParameterExceptionClassName = InvalidParameterException.class.getName();
        String propertyServerExceptionClassName = PropertyServerException.class.getName();
        String userNotAuthorizedExceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null) {
            String exceptionClassName = restResult.getExceptionClassName();
            if (exceptionClassName != null) {
                log.error("FFDC Response: {}", (Object)restResult.toString());
                if (exceptionClassName.equals(invalidParameterExceptionClassName)) {
                    this.throwInvalidParameterException(restResult);
                } else if (exceptionClassName.equals(userNotAuthorizedExceptionClassName)) {
                    this.throwUserNotAuthorizedException(restResult);
                } else if (exceptionClassName.equals(propertyServerExceptionClassName)) {
                    this.throwPropertyServerException(restResult);
                } else {
                    this.throwUnexpectedException(methodName, restResult);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("FFDC good Response: {}", (Object)restResult.toString());
            }
        }
    }

    public void detectAndThrowInvalidParameterException(FFDCResponse restResult) throws InvalidParameterException {
        String exceptionClassName = InvalidParameterException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            this.throwInvalidParameterException(restResult);
        }
    }

    @Deprecated
    public void detectAndThrowInvalidParameterException(String methodName, FFDCResponseBase restResult) throws InvalidParameterException {
        this.detectAndThrowInvalidParameterException(restResult);
    }

    @Deprecated
    public void detectAndThrowUserNotAuthorizedException(String methodName, FFDCResponseBase restResult) throws UserNotAuthorizedException {
        this.detectAndThrowUserNotAuthorizedException(restResult);
    }

    @Deprecated
    public void detectAndThrowPropertyServerException(String methodName, FFDCResponseBase restResult) throws PropertyServerException {
        this.detectAndThrowPropertyServerException(restResult);
    }

    private void throwInvalidParameterException(FFDCResponse restResult) throws InvalidParameterException {
        Object nameObject;
        String parameterName = null;
        Map<String, Object> exceptionProperties = restResult.getExceptionProperties();
        if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
            parameterName = (String)nameObject;
        }
        InvalidParameterException error = new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), restResult.getActionDescription(), restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), parameterName, restResult.getExceptionProperties());
        log.error("Detected Invalid Parameter Exception in REST Response", error);
        throw error;
    }

    public void detectAndThrowPropertyServerException(FFDCResponse restResult) throws PropertyServerException {
        String exceptionClassName = PropertyServerException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            this.throwPropertyServerException(restResult);
        }
    }

    private void throwPropertyServerException(FFDCResponse restResult) throws PropertyServerException {
        PropertyServerException error = new PropertyServerException(restResult.getRelatedHTTPCode(), this.getClass().getName(), restResult.getActionDescription(), restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        log.error("Property Server Error Exception returned by REST Call", error);
        throw error;
    }

    public void detectAndThrowUserNotAuthorizedException(FFDCResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            this.throwUserNotAuthorizedException(restResult);
        }
    }

    private void throwUserNotAuthorizedException(FFDCResponse restResult) throws UserNotAuthorizedException {
        Object userIdObject;
        String userId = null;
        Map<String, Object> exceptionProperties = restResult.getExceptionProperties();
        if (exceptionProperties != null && (userIdObject = exceptionProperties.get("userId")) != null) {
            userId = (String)userIdObject;
        }
        UserNotAuthorizedException error = new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), restResult.getActionDescription(), restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), userId, restResult.getExceptionProperties());
        log.error("User Not Authorized Exception", error);
        throw error;
    }

    public void handleUnexpectedException(Throwable error, String methodName, String serverName, String serverURL) throws PropertyServerException {
        log.error("Unexpected runtime exception returned from REST Call", error);
        throw new PropertyServerException(OMAGCommonErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, serverName, serverURL, error.getMessage()), this.getClass().getName(), methodName, error);
    }

    private void throwUnexpectedException(String methodName, FFDCResponse restResult) throws PropertyServerException {
        log.error(methodName + " returned unexpected exception", (Object)restResult);
        throw new PropertyServerException(OMAGCommonErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(restResult.getExceptionClassName(), methodName, restResult.getExceptionErrorMessage()), this.getClass().getName(), methodName);
    }

    protected void captureCheckedException(FFDCResponse response, OCFCheckedExceptionBase error, String exceptionClassName) {
        this.captureCheckedException(response, error, exceptionClassName, null);
    }

    protected void captureCheckedException(FFDCResponse response, OCFCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        if (error.getReportedCaughtException() != null) {
            response.setExceptionCausedBy(error.getReportedCaughtException().getClass().getName());
        }
        response.setActionDescription(error.getReportingActionDescription());
        response.setExceptionErrorMessage(error.getReportedErrorMessage());
        response.setExceptionErrorMessageId(error.getReportedErrorMessageId());
        response.setExceptionErrorMessageParameters(error.getReportedErrorMessageParameters());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(exceptionProperties);
    }

    public void captureExceptions(FFDCResponse response, Exception error, String methodName) {
        this.captureExceptions(response, error, methodName, null);
    }

    public void captureExceptions(FFDCResponse response, Exception error, String methodName, AuditLog auditLog) {
        log.error("Exception from " + methodName + " being packaged for return on REST call", error);
        if (error instanceof PropertyServerException) {
            this.capturePropertyServerException(response, (PropertyServerException)error);
        } else if (error instanceof UserNotAuthorizedException) {
            this.captureUserNotAuthorizedException(response, (UserNotAuthorizedException)error);
        } else if (error instanceof InvalidParameterException) {
            this.captureInvalidParameterException(response, (InvalidParameterException)error);
        } else {
            String message = error.getMessage();
            if (message == null) {
                message = "null";
            }
            ExceptionMessageDefinition messageDefinition = OMAGCommonErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(error.getClass().getName(), methodName, message);
            response.setRelatedHTTPCode(messageDefinition.getHttpErrorCode());
            response.setExceptionClassName(PropertyServerException.class.getName());
            response.setExceptionCausedBy(error.getClass().getName());
            response.setActionDescription(methodName);
            response.setExceptionErrorMessage(messageFormatter.getFormattedMessage(messageDefinition));
            response.setExceptionErrorMessageId(messageDefinition.getMessageId());
            response.setExceptionErrorMessageParameters(messageDefinition.getMessageParams());
            response.setExceptionSystemAction(messageDefinition.getSystemAction());
            response.setExceptionUserAction(messageDefinition.getUserAction());
            response.setExceptionProperties(null);
            if (auditLog != null) {
                auditLog.logException(methodName, OMAGCommonAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(error.getClass().getName(), methodName, message), error);
            }
        }
    }

    public void captureInvalidParameterException(FFDCResponse response, InvalidParameterException error) {
        Map<String, Object> exceptionProperties = error.getRelatedProperties();
        String parameterName = error.getParameterName();
        if (parameterName != null) {
            if (exceptionProperties == null) {
                exceptionProperties = new HashMap<String, Object>();
            }
            exceptionProperties.put("parameterName", parameterName);
        }
        if (exceptionProperties != null) {
            this.captureCheckedException(response, error, InvalidParameterException.class.getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, error, InvalidParameterException.class.getName());
        }
    }

    public void capturePropertyServerException(FFDCResponse response, PropertyServerException error) {
        this.captureCheckedException(response, error, PropertyServerException.class.getName());
    }

    public void captureUserNotAuthorizedException(FFDCResponse response, UserNotAuthorizedException error) {
        Map<String, Object> exceptionProperties = error.getRelatedProperties();
        String userId = error.getUserId();
        if (userId != null) {
            if (exceptionProperties == null) {
                exceptionProperties = new HashMap<String, Object>();
            }
            exceptionProperties.put("userId", userId);
        }
        if (exceptionProperties != null) {
            this.captureCheckedException(response, error, UserNotAuthorizedException.class.getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, error, UserNotAuthorizedException.class.getName());
        }
    }
}

