/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectorReport {
    private ComponentDescription componentDescription = null;
    private ConnectorType connectorType = null;
    private long refreshTimeInterval = 0L;
    private boolean usesBlockingCalls = false;
    private List<String> supportedRequestTypes = null;
    private List<String> supportedRequestParameters = null;
    private List<String> supportedRequestSourceNames = null;
    private List<String> supportedActionTargetNames = null;
    private List<String> supportedGuards = null;

    public ConnectorReport() {
    }

    public ConnectorReport(ConnectorReport template) {
        if (template != null) {
            this.componentDescription = template.getComponentDescription();
            this.connectorType = template.getConnectorType();
            this.refreshTimeInterval = template.getRefreshTimeInterval();
            this.usesBlockingCalls = template.getUsesBlockingCalls();
            this.supportedRequestTypes = template.getSupportedRequestTypes();
            this.supportedRequestParameters = template.getSupportedRequestParameters();
            this.supportedRequestSourceNames = template.getSupportedRequestSourceNames();
            this.supportedActionTargetNames = template.getSupportedActionTargetNames();
            this.supportedGuards = template.getSupportedGuards();
        }
    }

    public ComponentDescription getComponentDescription() {
        return this.componentDescription;
    }

    public void setComponentDescription(ComponentDescription componentDescription) {
        this.componentDescription = componentDescription;
    }

    public ConnectorType getConnectorType() {
        return this.connectorType;
    }

    public void setConnectorType(ConnectorType connectorType) {
        this.connectorType = connectorType;
    }

    public long getRefreshTimeInterval() {
        return this.refreshTimeInterval;
    }

    public void setRefreshTimeInterval(long refreshTimeInterval) {
        this.refreshTimeInterval = refreshTimeInterval;
    }

    public boolean getUsesBlockingCalls() {
        return this.usesBlockingCalls;
    }

    public void setUsesBlockingCalls(boolean usesBlockingCalls) {
        this.usesBlockingCalls = usesBlockingCalls;
    }

    public List<String> getSupportedRequestTypes() {
        return this.supportedRequestTypes;
    }

    public void setSupportedRequestTypes(List<String> supportedRequestTypes) {
        this.supportedRequestTypes = supportedRequestTypes;
    }

    public List<String> getSupportedRequestParameters() {
        return this.supportedRequestParameters;
    }

    public void setSupportedRequestParameters(List<String> supportedRequestParameters) {
        this.supportedRequestParameters = supportedRequestParameters;
    }

    public List<String> getSupportedRequestSourceNames() {
        return this.supportedRequestSourceNames;
    }

    public void setSupportedRequestSourceNames(List<String> supportedRequestSourceNames) {
        this.supportedRequestSourceNames = supportedRequestSourceNames;
    }

    public List<String> getSupportedActionTargetNames() {
        return this.supportedActionTargetNames;
    }

    public void setSupportedActionTargetNames(List<String> supportedActionTargetNames) {
        this.supportedActionTargetNames = supportedActionTargetNames;
    }

    public List<String> getSupportedGuards() {
        return this.supportedGuards;
    }

    public void setSupportedGuards(List<String> supportedGuards) {
        this.supportedGuards = supportedGuards;
    }

    public String toString() {
        return "ConnectorReport{componentDescription=" + this.componentDescription + ", connectorType=" + this.connectorType + ", refreshTimeInterval=" + this.refreshTimeInterval + ", usesBlockingCalls=" + this.usesBlockingCalls + ", supportedRequestTypes=" + this.supportedRequestTypes + ", supportedRequestParameters=" + this.supportedRequestParameters + ", supportedRequestSourceNames=" + this.supportedRequestSourceNames + ", supportedActionTargetNames=" + this.supportedActionTargetNames + ", supportedGuards=" + this.supportedGuards + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ConnectorReport that = (ConnectorReport)objectToCompare;
        return this.refreshTimeInterval == that.refreshTimeInterval && this.usesBlockingCalls == that.usesBlockingCalls && Objects.equals(this.componentDescription, that.componentDescription) && Objects.equals(this.connectorType, that.connectorType) && Objects.equals(this.supportedRequestTypes, that.supportedRequestTypes) && Objects.equals(this.supportedRequestParameters, that.supportedRequestParameters) && Objects.equals(this.supportedRequestSourceNames, that.supportedRequestSourceNames) && Objects.equals(this.supportedActionTargetNames, that.supportedActionTargetNames) && Objects.equals(this.supportedGuards, that.supportedGuards);
    }

    public int hashCode() {
        return Objects.hash(this.componentDescription, this.connectorType, this.refreshTimeInterval, this.usesBlockingCalls, this.supportedRequestTypes, this.supportedRequestParameters, this.supportedRequestSourceNames, this.supportedActionTargetNames, this.supportedGuards);
    }
}

