/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.GovernedReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Asset
extends GovernedReferenceable {
    private static final long serialVersionUID = 1L;
    protected String resourceName = null;
    protected String resourceDescription = null;
    protected String versionIdentifier = null;
    protected String displayName = null;
    protected String displaySummary = null;
    protected String displayDescription = null;
    protected String abbreviation = null;
    protected String usage = null;
    protected String connectionDescription = null;
    protected String owner = null;
    protected String ownerTypeName = null;
    protected String ownerPropertyName = null;
    protected OwnerType ownerType = null;
    protected List<String> zoneMembership = null;
    protected Map<String, String> origin = null;
    protected boolean isReferenceData = false;
    protected String name = null;
    protected String description = null;

    public Asset() {
    }

    public Asset(Asset template) {
        super(template);
        if (template != null) {
            this.resourceName = template.getResourceName();
            this.resourceDescription = template.getResourceDescription();
            this.versionIdentifier = template.getVersionIdentifier();
            this.displayName = template.getDisplayName();
            this.displaySummary = template.getDisplaySummary();
            this.displayDescription = template.getDisplayDescription();
            this.abbreviation = template.getAbbreviation();
            this.usage = template.getUsage();
            this.connectionDescription = template.getConnectionDescription();
            this.owner = template.getOwner();
            this.ownerTypeName = template.getOwnerTypeName();
            this.ownerPropertyName = template.getOwnerPropertyName();
            this.ownerType = template.getOwnerType();
            this.zoneMembership = template.getZoneMembership();
            this.origin = template.getAssetOrigin();
            this.isReferenceData = template.isReferenceData();
            this.description = template.getDescription();
            this.name = template.getName();
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String name) {
        this.resourceName = name;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.resourceName;
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplaySummary() {
        return this.displaySummary;
    }

    public void setDisplaySummary(String displaySummary) {
        this.displaySummary = displaySummary;
    }

    public String getDisplayDescription() {
        return this.displayDescription;
    }

    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getConnectionDescription() {
        return this.connectionDescription;
    }

    public void setConnectionDescription(String connectionDescription) {
        this.connectionDescription = connectionDescription;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String description) {
        this.resourceDescription = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwnerTypeName() {
        return this.ownerTypeName;
    }

    public void setOwnerTypeName(String ownerTypeName) {
        this.ownerTypeName = ownerTypeName;
    }

    public String getOwnerPropertyName() {
        return this.ownerPropertyName;
    }

    public void setOwnerPropertyName(String ownerPropertyName) {
        this.ownerPropertyName = ownerPropertyName;
    }

    public OwnerType getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(OwnerType ownerType) {
        this.ownerType = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public Map<String, String> getAssetOrigin() {
        if (this.origin == null) {
            return null;
        }
        if (this.origin.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.origin);
    }

    public void setAssetOrigin(Map<String, String> origin) {
        this.origin = origin;
    }

    public boolean isReferenceData() {
        return this.isReferenceData;
    }

    public void setReferenceData(boolean referenceData) {
        this.isReferenceData = referenceData;
    }

    @Deprecated
    public String getName() {
        if (this.name == null) {
            if (this.resourceName != null) {
                return this.resourceName;
            }
            return this.displayName;
        }
        return this.name;
    }

    @Deprecated
    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public String getDescription() {
        if (this.description == null) {
            if (this.resourceDescription != null) {
                return this.resourceDescription;
            }
            return this.displayDescription;
        }
        return this.description;
    }

    @Deprecated
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "Asset{resourceName='" + this.resourceName + "', resourceDescription='" + this.resourceDescription + "', versionIdentifier='" + this.versionIdentifier + "', displayName='" + this.displayName + "', displaySummary='" + this.displaySummary + "', displayDescription='" + this.displayDescription + "', abbreviation='" + this.abbreviation + "', usage='" + this.usage + "', connectionDescription='" + this.connectionDescription + "', owner='" + this.owner + "', ownerTypeName='" + this.ownerTypeName + "', ownerPropertyName='" + this.ownerPropertyName + "', ownerType=" + this.ownerType + ", zoneMembership=" + this.zoneMembership + ", origin=" + this.origin + ", isReferenceData=" + this.isReferenceData + ", name='" + this.name + "', description='" + this.description + "', assetOrigin=" + this.getAssetOrigin() + ", referenceData=" + this.isReferenceData() + ", URL='" + this.getURL() + "', extendedProperties=" + this.getExtendedProperties() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", versions=" + this.getVersions() + ", GUID='" + this.getGUID() + "', classifications=" + this.getClassifications() + ", meanings=" + this.getMeanings() + ", searchKeywords=" + this.getSearchKeywords() + ", headerVersion=" + this.getHeaderVersion() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Asset)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Asset asset = (Asset)objectToCompare;
        return this.isReferenceData == asset.isReferenceData && Objects.equals(this.resourceName, asset.resourceName) && Objects.equals(this.resourceDescription, asset.resourceDescription) && Objects.equals(this.versionIdentifier, asset.versionIdentifier) && Objects.equals(this.displayName, asset.displayName) && Objects.equals(this.displaySummary, asset.displaySummary) && Objects.equals(this.displayDescription, asset.displayDescription) && Objects.equals(this.abbreviation, asset.abbreviation) && Objects.equals(this.usage, asset.usage) && Objects.equals(this.connectionDescription, asset.connectionDescription) && Objects.equals(this.owner, asset.owner) && Objects.equals(this.ownerTypeName, asset.ownerTypeName) && Objects.equals(this.ownerPropertyName, asset.ownerPropertyName) && this.ownerType == asset.ownerType && Objects.equals(this.zoneMembership, asset.zoneMembership) && Objects.equals(this.origin, asset.origin) && Objects.equals(this.name, asset.name) && Objects.equals(this.description, asset.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resourceName, this.resourceDescription, this.versionIdentifier, this.displayName, this.displaySummary, this.displayDescription, this.abbreviation, this.usage, this.connectionDescription, this.owner, this.ownerTypeName, this.ownerPropertyName, this.ownerType, this.zoneMembership, this.origin, this.isReferenceData, this.name, this.description);
    }
}

