/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Comment
extends Referenceable {
    private static final long serialVersionUID = 1L;
    protected CommentType commentType = null;
    protected String commentText = null;
    protected String user = null;
    protected boolean isPublic = false;

    public Comment() {
    }

    public Comment(Comment template) {
        super(template);
        if (template != null) {
            this.commentType = template.getCommentType();
            this.user = template.getUser();
            this.commentText = template.getCommentText();
            this.isPublic = template.isPublic;
        }
    }

    public CommentType getCommentType() {
        return this.commentType;
    }

    public void setCommentType(CommentType commentType) {
        this.commentType = commentType;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean aPublic) {
        this.isPublic = aPublic;
    }

    @Override
    public String toString() {
        return "Comment{commentType=" + this.commentType + ", commentText='" + this.commentText + "', user='" + this.user + "', isPublic=" + this.isPublic + ", URL='" + this.getURL() + "', extendedProperties=" + this.getExtendedProperties() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", origin=" + this.getOrigin() + ", versions=" + this.getVersions() + ", GUID='" + this.getGUID() + "', classifications=" + this.getClassifications() + ", headerVersion=" + this.getHeaderVersion() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Comment comment = (Comment)objectToCompare;
        return this.isPublic == comment.isPublic && this.getCommentType() == comment.getCommentType() && Objects.equals(this.getCommentText(), comment.getCommentText()) && Objects.equals(this.getUser(), comment.getUser());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getCommentType(), this.getCommentText(), this.getUser(), this.isPublic});
    }
}

