/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;

public class OpenMetadataStore {
    private final OpenMetadataClient openMetadataClient;
    private final String userId;

    public OpenMetadataStore(OpenMetadataClient openMetadataClient, String userId) {
        this.openMetadataClient = openMetadataClient;
        this.userId = userId;
    }

    public OpenMetadataElement getMetadataElementByGUID(String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataElementByGUID(this.userId, elementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public OpenMetadataElement getMetadataElementByUniqueName(String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataElementByUniqueName(this.userId, uniqueName, uniquePropertyName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String getMetadataElementGUIDByUniqueName(String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataElementGUIDByUniqueName(this.userId, uniqueName, uniquePropertyName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String searchString, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.findMetadataElementsWithString(this.userId, searchString, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getRelatedMetadataElements(this.userId, elementGUID, startingAtEnd, relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElements(String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.findMetadataElements(this.userId, metadataElementTypeName, metadataElementSubtypeName, searchProperties, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String relationshipTypeName, SearchProperties searchProperties, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.findRelationshipsBetweenMetadataElements(this.userId, relationshipTypeName, searchProperties, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }
}

