/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ActionTargetElement
extends NewActionTarget {
    private static final long serialVersionUID = 1L;
    private GovernanceActionStatus status = null;
    private Date startDate = null;
    private Date completionDate = null;
    private String completionMessage = null;
    private OpenMetadataElement targetElement = null;

    public ActionTargetElement() {
    }

    public ActionTargetElement(ActionTargetElement template) {
        super(template);
        if (template != null) {
            this.status = template.getStatus();
            this.startDate = template.getStartDate();
            this.completionDate = template.getCompletionDate();
            this.completionMessage = template.getCompletionMessage();
            this.targetElement = template.getTargetElement();
        }
    }

    public GovernanceActionStatus getStatus() {
        return this.status;
    }

    public void setStatus(GovernanceActionStatus status) {
        this.status = status;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public String getCompletionMessage() {
        return this.completionMessage;
    }

    public void setCompletionMessage(String completionMessage) {
        this.completionMessage = completionMessage;
    }

    public OpenMetadataElement getTargetElement() {
        return this.targetElement;
    }

    public void setTargetElement(OpenMetadataElement targetElement) {
        this.targetElement = targetElement;
    }

    @Override
    public String toString() {
        return "ActionTargetElement{status=" + this.status + ", startDate=" + this.startDate + ", completionDate=" + this.completionDate + ", completionMessage='" + this.completionMessage + "', targetElement=" + this.targetElement + ", actionTargetName='" + this.getActionTargetName() + "', actionTargetGUID='" + this.getActionTargetGUID() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ActionTargetElement)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ActionTargetElement that = (ActionTargetElement)objectToCompare;
        if (this.status != that.status) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals(that.startDate) : that.startDate != null) {
            return false;
        }
        if (this.completionDate != null ? !this.completionDate.equals(that.completionDate) : that.completionDate != null) {
            return false;
        }
        if (this.completionMessage != null ? !this.completionMessage.equals(that.completionMessage) : that.completionMessage != null) {
            return false;
        }
        return this.targetElement != null ? this.targetElement.equals(that.targetElement) : that.targetElement == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.completionDate != null ? this.completionDate.hashCode() : 0);
        result = 31 * result + (this.completionMessage != null ? this.completionMessage.hashCode() : 0);
        result = 31 * result + (this.targetElement != null ? this.targetElement.hashCode() : 0);
        return result;
    }
}

