/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFRuntimeException;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.EnumTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;

public class PropertyHelper {
    public void validateGUID(String guid, String guidParameter, String methodName) throws InvalidParameterException {
        if (guid == null || guid.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.NULL_GUID.getMessageDefinition(guidParameter, methodName), this.getClass().getName(), methodName, guidParameter);
        }
    }

    public void validateMandatoryName(String name, String nameParameter, String methodName) throws InvalidParameterException {
        if (name == null || name.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.NULL_NAME.getMessageDefinition(nameParameter, methodName), this.getClass().getName(), methodName, nameParameter);
        }
    }

    private ElementProperties addPrimitivePropertyToInstance(ElementProperties properties, String propertyName, Object propertyValue, PrimitiveTypeCategory propertyCategory) {
        if (propertyValue != null) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
            primitiveTypePropertyValue.setPrimitiveTypeCategory(propertyCategory);
            primitiveTypePropertyValue.setPrimitiveValue(propertyValue);
            primitiveTypePropertyValue.setTypeName(propertyCategory.getName());
            resultingProperties.setProperty(propertyName, primitiveTypePropertyValue);
            return resultingProperties;
        }
        return properties;
    }

    public ElementProperties addStringProperty(ElementProperties properties, String propertyName, String propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
    }

    public ElementProperties addIntProperty(ElementProperties properties, String propertyName, int propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT);
    }

    public ElementProperties addLongProperty(ElementProperties properties, String propertyName, long propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG);
    }

    public ElementProperties addFloatProperty(ElementProperties properties, String propertyName, float propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, Float.valueOf(propertyValue), PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_FLOAT);
    }

    public ElementProperties addDateProperty(ElementProperties properties, String propertyName, Date propertyValue) {
        Long longValue = propertyValue.getTime();
        return this.addPrimitivePropertyToInstance(properties, propertyName, longValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE);
    }

    public ElementProperties addBooleanProperty(ElementProperties properties, String propertyName, boolean propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
    }

    public ElementProperties addEnumProperty(ElementProperties properties, String propertyName, String propertyType, String symbolicName) {
        ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
        EnumTypePropertyValue enumTypePropertyValue = new EnumTypePropertyValue();
        enumTypePropertyValue.setSymbolicName(symbolicName);
        enumTypePropertyValue.setTypeName(propertyType);
        resultingProperties.setProperty(propertyName, enumTypePropertyValue);
        return resultingProperties;
    }

    public ElementProperties addStringArrayProperty(ElementProperties properties, String propertyName, List<String> arrayValues) {
        if (arrayValues != null && !arrayValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ArrayTypePropertyValue arrayTypePropertyValue = new ArrayTypePropertyValue();
            arrayTypePropertyValue.setTypeName("array<string>");
            arrayTypePropertyValue.setArrayCount(arrayValues.size());
            int index = 0;
            for (String arrayValue : arrayValues) {
                PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
                primitiveTypePropertyValue.setPrimitiveValue(arrayValue);
                arrayTypePropertyValue.setArrayValue(index, primitiveTypePropertyValue);
                ++index;
            }
            resultingProperties.setProperty(propertyName, arrayTypePropertyValue);
            return resultingProperties;
        }
        return properties;
    }

    public ElementProperties addMapProperty(ElementProperties properties, String propertyName, Map<String, Object> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addPropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                mapTypePropertyValue.setTypeName("map<string,object>");
                mapTypePropertyValue.setMapValues(mapElementProperties);
                resultingProperties.setProperty(propertyName, mapTypePropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addPropertyMap(ElementProperties properties, Map<String, Object> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                Object mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue instanceof String) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Integer) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Long) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Short) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_SHORT);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_SHORT.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Date) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE.getName());
                    Long timestamp = ((Date)mapPropertyValue).getTime();
                    primitiveTypePropertyValue.setPrimitiveValue(timestamp);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Character) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_CHAR);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_CHAR.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Byte) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BYTE);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BYTE.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Boolean) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Float) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_FLOAT);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_FLOAT.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigDecimal) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigInteger) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGINTEGER);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGINTEGER.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Double) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DOUBLE);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof List) {
                    List propertyAsList = (List)mapPropertyValue;
                    ArrayTypePropertyValue arrayTypePropertyValue = new ArrayTypePropertyValue();
                    if (propertyAsList.size() != 0) {
                        int index = 0;
                        HashMap<String, Object> arrayPropertyAsMap = new HashMap<String, Object>();
                        for (Object arrayValueObject : propertyAsList) {
                            arrayPropertyAsMap.put(Integer.toString(index), arrayValueObject);
                            ++index;
                        }
                        arrayTypePropertyValue.setArrayValues(this.addPropertyMap(null, arrayPropertyAsMap));
                        arrayTypePropertyValue.setArrayCount(index);
                    }
                    arrayTypePropertyValue.setTypeName("array");
                    resultingProperties.setProperty(mapPropertyName, arrayTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Map) {
                    Map propertyAsMap = (Map)mapPropertyValue;
                    MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                    mapTypePropertyValue.setMapValues(this.addPropertyMap(null, propertyAsMap));
                    mapTypePropertyValue.setTypeName("map");
                    resultingProperties.setProperty(mapPropertyName, mapTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue == null) continue;
                primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
                primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getName());
                primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addStringMapProperty(ElementProperties properties, String propertyName, Map<String, String> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addStringPropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                mapTypePropertyValue.setMapValues(mapElementProperties);
                mapTypePropertyValue.setTypeName("map<string,string>");
                resultingProperties.setProperty(propertyName, mapTypePropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addStringPropertyMap(ElementProperties properties, Map<String, String> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                String mapPropertyValue = mapValues.get(mapPropertyName);
                PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
                primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public Map<String, String> getStringMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, String> stringMapFromProperty = new HashMap<String, String>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                stringMapFromProperty.put(mapPropertyName, actualPropertyValue.toString());
            }
            if (!stringMapFromProperty.isEmpty()) {
                return stringMapFromProperty;
            }
        }
        return null;
    }

    public Map<String, Boolean> getBooleanMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Boolean> booleanMap = new HashMap<String, Boolean>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                booleanMap.put(mapPropertyName, (Boolean)actualPropertyValue);
            }
            if (!booleanMap.isEmpty()) {
                return booleanMap;
            }
        }
        return null;
    }

    public Map<String, Long> getLongMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Long> longMap = new HashMap<String, Long>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                longMap.put(mapPropertyName, (Long)actualPropertyValue);
            }
            if (!longMap.isEmpty()) {
                return longMap;
            }
        }
        return null;
    }

    public Map<String, Integer> getIntegerMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Integer> integerMap = new HashMap<String, Integer>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                integerMap.put(mapPropertyName, (Integer)actualPropertyValue);
            }
            if (!integerMap.isEmpty()) {
                return integerMap;
            }
        }
        return null;
    }

    public Map<String, Object> getMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getMapFromProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                if (propertyValue instanceof MapTypePropertyValue) {
                    MapTypePropertyValue mapTypePropertyValue = (MapTypePropertyValue)propertyValue;
                    return this.getElementPropertiesAsMap(mapTypePropertyValue.getMapValues());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getMapFromProperty");
            }
        }
        return null;
    }

    public Map<String, Object> getElementPropertiesAsMap(ElementProperties properties) {
        if (properties != null) {
            Map<String, PropertyValue> propertyValues = properties.getPropertyValueMap();
            HashMap<String, Object> resultingMap = new HashMap<String, Object>();
            if (propertyValues != null) {
                for (String mapPropertyName : propertyValues.keySet()) {
                    PropertyValue actualPropertyValue = properties.getPropertyValue(mapPropertyName);
                    if (actualPropertyValue == null) continue;
                    if (actualPropertyValue instanceof PrimitiveTypePropertyValue) {
                        PrimitiveTypePropertyValue primitiveTypePropertyValue = (PrimitiveTypePropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, primitiveTypePropertyValue.getPrimitiveValue());
                        continue;
                    }
                    resultingMap.put(mapPropertyName, actualPropertyValue);
                }
            }
            return resultingMap;
        }
        return null;
    }

    public String getStringProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getStringProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    return primitiveTypePropertyValue.getPrimitiveValue().toString();
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getStringProperty");
            }
        }
        return null;
    }

    public int getIntProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getIntProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    return Integer.parseInt(primitiveTypePropertyValue.getPrimitiveValue().toString());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getIntProperty");
            }
        }
        return 0;
    }

    public long getLongProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getLongProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    return Long.parseLong(primitiveTypePropertyValue.getPrimitiveValue().toString());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getLongProperty");
            }
        }
        return 0L;
    }

    public Date getDateProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getDateProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    Long timestamp = (Long)primitiveTypePropertyValue.getPrimitiveValue();
                    return new Date(timestamp);
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getDateProperty");
            }
        }
        return null;
    }

    public boolean getBooleanProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getBooleanProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    return Boolean.parseBoolean(primitiveTypePropertyValue.getPrimitiveValue().toString());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getBooleanProperty");
            }
        }
        return false;
    }

    public SearchProperties getSearchProperties(ElementProperties properties, MatchCriteria matchCriteria) {
        SearchProperties matchProperties = null;
        if (properties != null) {
            matchProperties = new SearchProperties();
            ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
            Iterator<String> propertyNames = properties.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = propertyNames.next();
                PropertyCondition propertyCondition = new PropertyCondition();
                propertyCondition.setProperty(propertyName);
                PropertyValue propertyValue = properties.getPropertyValue(propertyName);
                if (propertyValue instanceof PrimitiveTypePropertyValue && ((PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory().equals(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING)) {
                    propertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                } else {
                    propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                }
                propertyCondition.setValue(propertyValue);
                conditions.add(propertyCondition);
            }
            matchProperties.setConditions(conditions);
            matchProperties.setMatchCriteria(matchCriteria);
        }
        return matchProperties;
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        throw new GAFRuntimeException(GAFErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName);
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName, Exception unexpectedException) {
        throw new GAFRuntimeException(GAFErrorCode.HELPER_LOGIC_EXCEPTION.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName, unexpectedException);
    }
}

