/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.connectors;

import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFErrorCode;

public abstract class IntegrationConnectorBase
extends ConnectorBase
implements IntegrationConnector,
AuditLoggingComponent,
VirtualConnectorExtension {
    protected AuditLog auditLog = null;
    protected String connectorName = null;
    protected IntegrationContext integrationContext = null;
    protected List<Connector> embeddedConnectors = null;

    @Override
    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    @Override
    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    @Override
    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    @Override
    public void setContext(IntegrationContext integrationContext) {
        this.integrationContext = integrationContext;
    }

    @Override
    public void engage() throws ConnectorCheckedException {
        String actionDescription = "Calling default engage() method";
        throw new ConnectorCheckedException(OIFErrorCode.ENGAGE_IMPLEMENTATION_MISSING.getMessageDefinition(this.connectorName), this.getClass().getName(), "Calling default engage() method");
    }

    @Override
    public synchronized void disconnect() throws ConnectorCheckedException {
        super.disconnectConnectors(this.embeddedConnectors);
        super.disconnect();
    }
}

