/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationGovernanceContext;
import org.odpi.openmetadata.frameworks.integration.context.MultiLanguageManagement;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.integration.context.StewardshipAction;
import org.odpi.openmetadata.frameworks.integration.context.ValidMetadataValues;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.reports.IntegrationReportWriter;

public class IntegrationContext {
    protected final OpenIntegrationClient openIntegrationClient;
    protected final OpenMetadataClient openMetadataStoreClient;
    protected final String userId;
    protected final String externalSourceGUID;
    protected final String externalSourceName;
    protected boolean externalSourceIsHome = true;
    protected final String connectorName;
    protected final String integrationConnectorGUID;
    protected final PermittedSynchronization permittedSynchronization;
    private final IntegrationGovernanceContext integrationGovernanceContext;
    protected final IntegrationReportWriter integrationReportWriter;
    protected final int maxPageSize;
    private boolean isRefreshInProgress = false;

    public IntegrationContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, OpenMetadataClient openMetadataStoreClient, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String externalSourceGUID, String externalSourceName, String integrationConnectorGUID, int maxPageSize) {
        this.openIntegrationClient = openIntegrationClient;
        this.openMetadataStoreClient = openMetadataStoreClient;
        this.permittedSynchronization = permittedSynchronization;
        this.userId = connectorUserId;
        this.connectorName = connectorName;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.integrationConnectorGUID = integrationConnectorGUID;
        this.maxPageSize = maxPageSize;
        this.integrationReportWriter = generateIntegrationReport ? new IntegrationReportWriter(serverName, connectorId, connectorName, this.userId, openIntegrationClient, openMetadataStoreClient) : null;
        this.integrationGovernanceContext = this.constructIntegrationGovernanceContext(openMetadataStoreClient, connectorUserId, externalSourceGUID, externalSourceName, this.integrationReportWriter);
    }

    private IntegrationGovernanceContext constructIntegrationGovernanceContext(OpenMetadataClient openMetadataStore, String userId, String externalSourceGUID, String externalSourceName, IntegrationReportWriter integrationReportWriter) {
        if (this.openMetadataStoreClient != null) {
            OpenMetadataAccess openMetadataAccess = new OpenMetadataAccess(openMetadataStore, userId, externalSourceGUID, externalSourceName, integrationReportWriter);
            MultiLanguageManagement multiLanguageManagement = new MultiLanguageManagement(openMetadataStore, userId);
            StewardshipAction stewardshipAction = new StewardshipAction(openMetadataStore, userId);
            ValidMetadataValues validMetadataValues = new ValidMetadataValues(openMetadataStore, userId);
            return new IntegrationGovernanceContext(openMetadataAccess, multiLanguageManagement, stewardshipAction, validMetadataValues);
        }
        return null;
    }

    public List<CatalogTarget> getCatalogTargets(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.openIntegrationClient != null && this.integrationConnectorGUID != null) {
            return this.openIntegrationClient.getCatalogTargets(this.userId, this.integrationConnectorGUID, startingFrom, maximumResults);
        }
        return null;
    }

    public String getMetadataSourceQualifiedName() {
        return this.externalSourceName;
    }

    public PermittedSynchronization getPermittedSynchronization() {
        return this.permittedSynchronization;
    }

    public IntegrationGovernanceContext getIntegrationGovernanceContext() {
        return this.integrationGovernanceContext;
    }

    public void setActiveReportPublishing(boolean flag) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setActiveReportPublishing(flag);
        }
    }

    public void startRecording() {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.startRecording();
        }
    }

    protected void reportAnchorGUID(String elementGUID, String anchorGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(elementGUID, anchorGUID);
        }
    }

    protected void reportParentGUID(String elementGUID, String parentGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(elementGUID, parentGUID);
        }
    }

    protected void reportElementCreation(String elementGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(elementGUID);
        }
    }

    protected void reportElementUpdate(String elementGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    protected void reportElementDelete(String elementGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(elementGUID);
        }
    }

    public void publishReport() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.publishReport();
        }
    }

    public boolean isRefreshInProgress() {
        return this.isRefreshInProgress;
    }

    void setRefreshInProgress(boolean refreshInProgress) {
        this.isRefreshInProgress = refreshInProgress;
    }

    public String getAnchorGUID(ElementHeader elementHeader) {
        if (elementHeader.getClassifications() != null) {
            for (ElementClassification classification : elementHeader.getClassifications()) {
                Object anchorGUID;
                Map<String, Object> properties;
                if (!classification.getClassificationName().equals("Anchors") || (properties = classification.getClassificationProperties()) == null || (anchorGUID = properties.get("anchorGUID")) == null) continue;
                return anchorGUID.toString();
            }
        }
        return null;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public boolean isTypeOf(ElementHeader elementHeader, String typeName) {
        return this.isTypeOf(elementHeader.getType(), typeName);
    }

    public boolean isTypeOf(ElementType elementType, String typeName) {
        if (elementType != null) {
            ArrayList<String> elementTypeNames = new ArrayList<String>();
            elementTypeNames.add(elementType.getTypeName());
            if (elementType.getSuperTypeNames() != null) {
                elementTypeNames.addAll(elementType.getSuperTypeNames());
            }
            if (elementTypeNames.contains(typeName)) {
                return true;
            }
        }
        return false;
    }
}

