/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.context;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;
import org.odpi.openmetadata.frameworks.integration.reports.IntegrationReportWriter;

public class OpenMetadataAccess {
    private final OpenMetadataClient openMetadataStore;
    private final String userId;
    private final String externalSourceGUID;
    private final String externalSourceName;
    private final IntegrationReportWriter reportWriter;

    public OpenMetadataAccess(OpenMetadataClient openMetadataStore, String userId, String externalSourceGUID, String externalSourceName, IntegrationReportWriter reportWriter) {
        this.openMetadataStore = openMetadataStore;
        this.userId = userId;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.reportWriter = reportWriter;
    }

    public OpenMetadataElement getMetadataElementByGUID(String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getMetadataElementByGUID(this.userId, elementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public OpenMetadataElement getMetadataElementByUniqueName(String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getMetadataElementByUniqueName(this.userId, uniqueName, uniquePropertyName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String getMetadataElementGUIDByUniqueName(String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getMetadataElementGUIDByUniqueName(this.userId, uniqueName, uniquePropertyName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String searchString, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.findMetadataElementsWithString(this.userId, searchString, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getRelatedMetadataElements(this.userId, elementGUID, startingAtEnd, relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElements(String metadataElementTypeName, List<String> metadataElementSubtypeNames, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.findMetadataElements(this.userId, metadataElementTypeName, metadataElementSubtypeNames, searchProperties, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String relationshipTypeName, SearchProperties searchProperties, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.findRelationshipsBetweenMetadataElements(this.userId, relationshipTypeName, searchProperties, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public RelatedMetadataElements getRelationshipByGUID(String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getRelationshipByGUID(this.userId, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataElementGUID = this.openMetadataStore.createMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties, templateGUID);
        if (metadataElementGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(metadataElementGUID);
        }
        return metadataElementGUID;
    }

    public void updateMetadataElementInStore(String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.updateMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateMetadataElementStatusInStore(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.updateMetadataElementStatusInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, forLineage, forDuplicateProcessing, newElementStatus, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateMetadataElementEffectivityInStore(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.updateMetadataElementEffectivityInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void deleteMetadataElementInStore(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.deleteMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementDelete(metadataElementGUID);
        }
    }

    public void classifyMetadataElementInStore(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.classifyMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void reclassifyMetadataElementInStore(String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.reclassifyMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, classificationName, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateClassificationEffectivityInStore(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.updateClassificationEffectivityInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void declassifyMetadataElementInStore(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.declassifyMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public String createRelatedElementsInStore(String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String relationshipGUID = this.openMetadataStore.createRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
        if (relationshipGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(relationshipGUID);
        }
        return relationshipGUID;
    }

    public void updateRelatedElementsInStore(String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.updateRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(relationshipGUID);
        }
    }

    public void updateRelatedElementsEffectivityInStore(String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.updateRelatedElementsEffectivityInStore(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(relationshipGUID);
        }
    }

    public void deleteRelatedElementsInStore(String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.deleteRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementDelete(relationshipGUID);
        }
    }
}

